package com.cku.oa.groomer.web;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.enums.DogCategorysEnum;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 美容师资格证书Controller
 * @author cxt
 * @version 2016-07-22
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerQualificationCertificate")
public class GroomerQualificationCertificateController extends BaseController {

	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	private GroomerRegisterService groomerRegisterService;
	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	private MemberService memberService;

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	@Autowired
	private GroomerShowRefereeService showRefereeService;
	@ModelAttribute
	public GroomerQualificationCertificate get(@RequestParam(required=false) String id) {
		GroomerQualificationCertificate entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerQualificationCertificateService.get(id);
		}
		if (entity == null){
			entity = new GroomerQualificationCertificate();
		}
		return entity;
	}
	


	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = "form")
	public String form(GroomerQualificationCertificate groomerQualificationCertificate, Model model) {
		List<String> showRefereeList = showRefereeService.findAllShowRefereeNameEn();
		List<String> dogCateGoryNames = DogCategorysEnum.getByCategoryName();
		/*groomerQualificationCertificate = groomerQualificationCertificateService.getGroomerQualificationCertificateById(groomerQualificationCertificate.getId());*/
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.getByCertificateId(groomerQualificationCertificate.getId());
		groomerQualificationCertificate.setFciGroomerQualificationCertificate(fciGroomerQualificationCertificate);
		model.addAttribute("dogCateGoryNames", dogCateGoryNames);
		model.addAttribute("groomerQualificationCertificate", groomerQualificationCertificate);
		model.addAttribute("showRefereeList", showRefereeList);
		logger.info("groomerQualificationCertificate form -------groomerQualificationCertificate : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		logger.info("groomerQualificationCertificate form -------showRefereeList : {}", JSONObjectUtils.toJsonString(showRefereeList));
		return "oa/groomer/groomerQualificationCertificateForm";

	}
	
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = "view")
	public String view(GroomerQualificationCertificate groomerQualificationCertificate, Model model) {
		model.addAttribute("groomerQualificationCertificate", groomerQualificationCertificate);
		return "oa/groomer/groomerQualificationCertificateView";
	}
	
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "save")
	public String save(GroomerQualificationCertificate groomerQualificationCertificate, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerQualificationCertificate)){
			return form(groomerQualificationCertificate, model);
		}
		if (Objects.nonNull(groomerQualificationCertificate.getFciGroomerQualificationCertificate()) && StringUtils.isNotBlank(groomerQualificationCertificate.getFciGroomerQualificationCertificate().getDogCategory())) {
			FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.getByCertificateId(groomerQualificationCertificate.getId());
			if (Objects.nonNull(fciGroomerQualificationCertificate)) {
				fciGroomerQualificationCertificate.setDogCategory(groomerQualificationCertificate.getFciGroomerQualificationCertificate().getDogCategory());
				groomerQualificationCertificate.setFciGroomerQualificationCertificate(fciGroomerQualificationCertificate);
			}
		}

		groomerQualificationCertificateService.save(groomerQualificationCertificate);

		if("3".equals(groomerQualificationCertificate.getCertificateType())){
			addMessage(redirectAttributes, "保存宠物造型师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/petList/?repage";
		}else if("2".equals(groomerQualificationCertificate.getCertificateType())){
			addMessage(redirectAttributes, "保存国际宠物美容师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/internationalList/?repage";
		}else if("4".equals(groomerQualificationCertificate.getCertificateType())){
			addMessage(redirectAttributes, "保存国际宠物洗护师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/nurseList/?repage";
		}else{
			addMessage(redirectAttributes, "保存美容师资格证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/list/?repage";
		}
	}
	
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerQualificationCertificate groomerQualificationCertificate, RedirectAttributes redirectAttributes) {
		groomerQualificationCertificateService.delete(groomerQualificationCertificate);

		if("3".equals(groomerQualificationCertificate.getCertificateType())){
			addMessage(redirectAttributes, "删除宠物造型师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/petList/?repage";
		}else if("2".equals(groomerQualificationCertificate.getCertificateType())){
			addMessage(redirectAttributes, "删除国际宠物美容师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/internationalList/?repage";
		}else if("4".equals(groomerQualificationCertificate.getCertificateType())) {
			addMessage(redirectAttributes, "删除宠物洗护师证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/nurseList/?repage";
		}else{
			addMessage(redirectAttributes, "删除美容师资格证书成功");
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/list/?repage";
		}
	}
	
	/**
	 * 批量提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "reminder")
	public String reminder(HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		String ids = request.getParameter("ids");
		groomerQualificationCertificateService.reminder(ids);
		addMessage(redirectAttributes, "提醒成功");
		String[] id = ids.split(",");
		GroomerQualificationCertificate groomerQualificationCertificate = this.get(id[0]);
		if("3".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/petList/?repage";
		}else if("2".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/internationalList/?repage";
		}else if("4".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/nurseList/?repage";
		} else if("8".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/catNurseList/?repage";
		} else {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/list/?repage";
		}
	}

	/**
	 * 单个提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "reminderOne")
	public String reminderOne(String id,HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		groomerQualificationCertificateService.reminder(id);
		addMessage(redirectAttributes, "提醒成功");
		GroomerQualificationCertificate groomerQualificationCertificate = this.get(id);
		if("3".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/petList/?repage";
		}else if("2".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/internationalList/?repage";
		}else if("4".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/nurseList/?repage";
		} else if ("8".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/catNurseList/?repage";
		}else{
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/list/?repage";
		}
	}
	
	/**
	 * 生成资格证书号
	 * @Author chaixueteng
	 * @2016年8月3日下午1:39:10
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:create")
	@RequestMapping("createCode")
	public String createCode(GroomerQualificationCertificate groomerQualificationCertificate, RedirectAttributes redirectAttributes){
		logger.info("GroomerQualificationCertificateController createCode param : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		groomerQualificationCertificateService.createCode(groomerQualificationCertificate.getId());
		if ("3".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/petList/?repage";
		} else if ("2".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/internationalList/?repage";
		} else if ("4".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/nurseList/?repage";
		} else if ("6".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/pdg/list/?repage";
		} else if ("8".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/catNurseList/?repage";
		} else {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/list/?repage";
		}

	}
	
	/**
	 * 资格证书导出(搜索维度)
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:export")
    @RequestMapping(value = "export")
    public String export(GroomerQualificationCertificate groomerQualificationCertificate,HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			groomerQualificationCertificateService.export(groomerQualificationCertificate,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出资格证书失败！失败信息："+e.getMessage());
		}
		return null;
    }
	/**
	 * 美容资格证书打印
	 * @Author chaixueteng
	 * @2016年8月23日上午10:54:38
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:export")
    @RequestMapping(value = "print")
	public String print(String id,Model model){
		GroomerQualificationCertificate gg = groomerQualificationCertificateService.print(id);
		if("4".equals(gg.getCertificateType())) {
			gg.setLevelCn(DictUtils.getDictLabel(gg.getLevelCn(), "groomer_nurse_level", null));
			switch (gg.getLevelEn()) {
			case "PRIMARY":
				gg.setLevelEn("Primary Level");
				break;
			case "SENIOR":
				gg.setLevelEn("Senior Level");
				break;
			case "MATCH":
				gg.setLevelEn("Show Level");
				break;
			default:
				break;
			}
		}
		model.addAttribute("groomerQualificationCertificate", gg);

		if ("3".equals(gg.getCertificateType()) && "宠物造型师".equals(gg.getLevelEn())) {
			return "oa/groomer/groomerQualificationCertificatePrintPet";
		} else if ("3".equals(gg.getCertificateType()) && "金牌宠物造型师".equals(gg.getLevelEn())) {
			return "oa/groomer/groomerQualificationCertificatePrintGlodPet";
		} else if ("2".equals(gg.getCertificateType()) && "国际高级宠物美容师".equals(gg.getLevelEn())) {
			return "oa/groomer/groomerQualificationCertificatePrintISPG";
		} else if ("2".equals(gg.getCertificateType()) && "国际宠物美容师".equals(gg.getLevelEn())) {
			return "oa/groomer/groomerQualificationCertificatePrintIPG";
		} else if ("4".equals(gg.getCertificateType())) {
			return "oa/groomer/groomerQualificationCertificatePrintNurse";
		} else if ("6".equals(gg.getCertificateType())) {
			return "oa/groomer/pdgGroomerQualificationCertificatePrint";
		} else if ("8".equals(gg.getCertificateType())) {
			return "oa/groomer/groomerQualificationCertificatePrintCatNurse";
		} else {
			//return "oa/groomer/pdgGroomerQualificationCertificatePrint";
			return "oa/groomer/groomerQualificationCertificatePrint";
		}
	}
	/**
	 * 重置打印
	 * @Author chaixueteng
	 * @2016年8月22日下午5:47:58
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(String id, RedirectAttributes redirectAttributes){
		groomerQualificationCertificateService.resetPrint(id);
		GroomerQualificationCertificate groomerQualificationCertificate = this.get(id);
		if("3".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/petList/?repage";
		}else if("2".equals(groomerQualificationCertificate.getCertificateType())){
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/internationalList/?repage";
		}else if("4".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/nurseList/?repage";
		} else if("6".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/pdg/list/?repage";
		} else if("8".equals(groomerQualificationCertificate.getCertificateType())) {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/catNurseList/?repage";
		} else {
			return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificate/list/?repage";
		}
	}

	/**
	 * 资格证书列表
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("1");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificate";
	}
	/**
	 * 国际宠物美容师证书列表
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = {"internationalList", ""})
	public String internationalList(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("2");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificateInternational";
	}

	/**
	 * 宠物造型师证书列表
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = {"petList", ""})
	public String petList(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("3");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificatePet";
	}
	
	
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = {"nurseList", ""})
	public String nurseList(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("4");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificateNurse";
	}
	
	//立刻申领
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "applyFree")
	@ResponseBody
	public Object applyFree(HttpServletRequest request, HttpServletResponse response) {
		String id = request.getParameter("id");
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try{
			GroomerQualificationCertificate gqc = this.get(id);

			Member member1 = gqc.getMember();
			Member member = memberService.get(member1.getId());
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效！");
			}

			if (gqc == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无证书!");
			}else if ("2".equals(gqc.getPaymentState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书已经申领,请勿重复申领!");
			}
			//判断同类型证书
			List<GroomerQualificationCertificate> groomerQualificationCertificates = groomerQualificationCertificateDao.eqCertificatepay(member.getMemberCode(), gqc.getLevelEn(), gqc.getCertificateType());
			if(groomerQualificationCertificates.size()>0){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已经申领过该类型的证书，无需申领!");
			}
			GroomerRegister groomerRegister = groomerRegisterService.get(gqc.getRegisterId());
			if (groomerRegister == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "!");
			}
			//修改支付状态
			groomerQualificationCertificateDao.updatePayment(gqc);
			//更改申领状态
			groomerQualificationCertificateDao.updateCertificateState(id);
		}catch (Exception e){
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 美容资格证书打印
	 * @Author chaixueteng
	 * @2016年8月23日上午10:54:38
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:export")
	@RequestMapping(value = "/fci/print")
	public String printFci(String id,Model model){
		GroomerQualificationCertificate groomerQualificationCertificate = fciGroomerQualificationCertificateService.printAdditionalIssuanceFci(id);

		model.addAttribute("groomerQualificationCertificate", groomerQualificationCertificate);
		return "oa/groomer/fciGroomerQualificationCertificatePrint";

	}

	@RequiresPermissions("groomer:groomerQualificationCertificate:resetPrint")
	@RequestMapping(value = "/fci/resetPrint")
	public String resetPrintFci(String id,Model model){
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.get(id);
		//重置打印Fci状态
		fciGroomerQualificationCertificateService.resetPrintFci(fciGroomerQualificationCertificate);
		if (fciGroomerQualificationCertificate.getCertificateType().equals("7")) {
			return "redirect:" + Global.getAdminPath() + "/groomer/fciGroomerQualificationCertificate/list/?repage";
		}
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/list/?repage";
	}

	/**
	 * 单个提醒
	 * @Author chaixueteng
	 * @2016年8月2日上午10:54:23
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:edit")
	@RequestMapping(value = "fci/reminderOne")
	public String fciReminderOne(String id,HttpServletRequest request, HttpServletResponse response,RedirectAttributes redirectAttributes) {
		fciGroomerQualificationCertificateService.ficReminder(id);
		addMessage(redirectAttributes, "提醒成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerQualificationCertificate/list/?repage";
	}

	/**
	 * 派多格CKU国际美容师资格认证书列表
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = "/pdg/list")
	public String pdgGroomerQualificationCertificateList(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("6");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/pdgGroomerQualificationCertificate";
	}

	@RequestMapping(value = "/pdg/view")
	public String pdgView(GroomerQualificationCertificate groomerQualificationCertificate, Model model) {
		model.addAttribute("groomerQualificationCertificate", groomerQualificationCertificate);
		return "oa/groomer/pdgGroomerQualificationCertificateView";
	}

	@RequestMapping(value = "/pdg/form")
	public String pdgForm(GroomerQualificationCertificate groomerQualificationCertificate, Model model) {
		List<String> showRefereeList = showRefereeService.findAllShowRefereeNameEn();
		List<String> dogCateGoryNames = DogCategorysEnum.getByCategoryName();
		/*groomerQualificationCertificate = groomerQualificationCertificateService.getGroomerQualificationCertificateById(groomerQualificationCertificate.getId());*/
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = fciGroomerQualificationCertificateService.getByCertificateId(groomerQualificationCertificate.getId());
		groomerQualificationCertificate.setFciGroomerQualificationCertificate(fciGroomerQualificationCertificate);
		model.addAttribute("dogCateGoryNames", dogCateGoryNames);
		model.addAttribute("groomerQualificationCertificate", groomerQualificationCertificate);
		model.addAttribute("showRefereeList", showRefereeList);
		logger.info("groomerQualificationCertificate pdgForm -------groomerQualificationCertificate : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
		logger.info("groomerQualificationCertificate pdgForm -------showRefereeList : {}", JSONObjectUtils.toJsonString(showRefereeList));
		return "oa/groomer/pdgGroomerQualificationCertificateForm";
	}

	/**
	 * 伴侣猫洗护师证书列表
	 * @Author chaixueteng
	 * @2016年7月25日上午10:27:56
	 */
	@RequiresPermissions("groomer:groomerQualificationCertificate:view")
	@RequestMapping(value = {"catNurseList", ""})
	public String catNurseList(GroomerQualificationCertificate groomerQualificationCertificate, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerQualificationCertificate.setCertificateType("8");
		Page<GroomerQualificationCertificate> page = groomerQualificationCertificateService.findPage(new Page<GroomerQualificationCertificate>(request, response), groomerQualificationCertificate);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificateCatNurse";
	}

}