package com.cku.oa.groomer.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.StringUtils;

public class GroomerUtil {
	
	private static Map<String,String> map = new HashMap<>();
	
	private static Map<String,String> shortMap = new HashMap<>();
	
	private static Map<String,String> nurseMap = new HashMap<>();

	private static Map<String,String> catNurseMap = new HashMap<>();
	
	
	static {
		map.put("A", "A级");
		map.put("B", "B级");
		map.put("C", "C级");
		map.put("M", "教师级");
		map.put("MASTER", "教师级");
		map.put("教师级", "教师级");
		map.put("PRIMARY", "CKU国际宠物洗护师（初级）");
		map.put("SENIOR", "CKU国际宠物洗护师（高级）");
		map.put("MATCH", "CKU国际宠物洗护师（赛级）");
		map.put("国际高级宠物美容师", "国际高级宠物美容师");
		map.put("国际宠物美容师", "国际宠物美容师");
		map.put("宠物造型师", "宠物造型师");
		map.put("金牌宠物造型师", "金牌宠物造型师");
		map.put("PRIMARY LEVEL", "宠物级");
		map.put("PROFESSIONAL LEVEL", "专业级");
		
		shortMap.put("PRIMARY", "初");
		shortMap.put("SENIOR", "高");
		shortMap.put("MATCH", "赛");
		shortMap.put("MASTER", "教师");
		shortMap.put("PRIMARY LEVEL", "宠物");
		shortMap.put("PROFESSIONAL LEVEL", "专业");
		
		nurseMap.put("PRIMARY", "Primary Level");
		nurseMap.put("SENIOR", "Senior Level");
		nurseMap.put("MATCH", "Show Level");

		catNurseMap.put("PRIMARY LEVEL", "宠物级");
		catNurseMap.put("PROFESSIONAL LEVEL", "专业级");
		catNurseMap.put("MASTER", "教师级");


	}

	public static String getLevelCn(String levelEn) {
		return map.get(levelEn);
	}
	/**
	 * 洗护证书专用英文级别显示
	 * @param levelEn
	 * @return
	 */
	public static String getLevelEn(String levelEn) {
		return nurseMap.get(levelEn)!=null?nurseMap.get(levelEn):levelEn;
	}
	
	public static String getUrl(String avatar) {
		if(StringUtils.isNotBlank(avatar)&&!avatar.startsWith("http")) {
			return Global.getConfig("touxiangUrl") +"api/v1/open/groomerImage/" + avatar;
		}
		return avatar;
		
	}

	public static String transLevel(String levelEn) {
		return shortMap.get(levelEn)!=null?shortMap.get(levelEn):levelEn;
	}
	
	
	public static void sort(List<String> levels ) {
		String[] sort = {"A","B","C","MASTER","PRIMARY","SENIOR","MATCH"};
		List<String> sortList = new ArrayList<>(Arrays.asList(sort));
		new ArrayList<>(Arrays.asList(levels)).sort((a, b) -> {
			 return sortList.indexOf(a) - sortList.indexOf(b);
		});
	}
	
	public static String concatDogBreeds(String showDogBreed,String showDogBreedExtra) {
		if(StringUtils.isNotBlank(showDogBreed)&&StringUtils.isNotBlank(showDogBreedExtra)) {
			return showDogBreed+","+showDogBreedExtra;
		}else if(StringUtils.isBlank(showDogBreed)&&StringUtils.isNotBlank(showDogBreedExtra)) {
			return showDogBreedExtra;
		}
		return showDogBreed;
	}

	public static String getCatNurseLevelCn(String levelEn) {
		return catNurseMap.get(levelEn)!=null?catNurseMap.get(levelEn):levelEn;
	}

}