package com.cku.oa.groomer.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.RotationChartDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.RotationChart;
import com.cku.restful.v1.dog.vo.RotationChartVO;
import com.thinkgem.jeesite.common.service.CrudService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * 美容课程表Service
 * @author cxt
 * @version 2017-06-19
 */
@Service
@Transactional
public class RotationChartService extends CrudService<RotationChartDao, RotationChart> {

    @Autowired
    private GroomerCourseService groomerCourseService;

    //查重
    public void ISrepeat(RotationChart rotationChart){
        List<RotationChart> list = this.findList(new RotationChart());
        list.stream().filter((e)->{
            return e.getRotationIndex().equals(rotationChart.getRotationIndex());
        }).forEach(e->{
            if(e!=null  && !e.getId().equals(rotationChart.getId())){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "序号不允许重复！");
            }
        });
    }

    public List<RotationChartVO> findListByApp(HttpServletRequest request){
        RotationChart rotationChart = new RotationChart();
        List<RotationChart> list = findList(rotationChart);
        List<RotationChartVO> list1 = new ArrayList<>();
        list.stream().limit(5).forEach(e->{
            RotationChartVO rotationChartVO = new RotationChartVO();
            BeanUtils.copyProperties(e, rotationChartVO);
            if(StringUtils.isNotBlank(rotationChartVO.getRotationPicture())){
                String path = request.getContextPath();
                String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+rotationChartVO.getRotationPicture();
                rotationChartVO.setRotationPicture(imgPath);
            }
            //查询课程id
            if(StringUtils.isNotBlank(rotationChartVO.getRotationType()) && StringUtils.isNotBlank(rotationChartVO.getRotationCurriculum())){
                //查询课程id
                GroomerCourse courseByCode = groomerCourseService.getCourseByCode(rotationChartVO.getRotationCurriculum());
                rotationChartVO.setCourseId(courseByCode.getId());
            }
            list1.add(rotationChartVO);
        });
        return list1;

    }

    public List<GroomerCourse>  getGroomerCourse(RotationChart rotationChart){
        GroomerCourse groomerCourse = new GroomerCourse();
        groomerCourse.setCode(rotationChart.getRotationCurriculum());
        List<GroomerCourse> list = groomerCourseService.findList(groomerCourse);
        return list;
    }
}