/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛事裁判表Entity
 * @author lgl
 * @version 2016-07-14
 */
public class GroomerShowReferee extends DataEntity<GroomerShowReferee> {
	
	private static final long serialVersionUID = 1L;
	private String refereeNameCn;		// 裁判中文名
	private String refereeNameEn;		// 裁判英文名
	private String refereeSex;		// 裁判性别
	private String refereeCitizenship;		// 裁判国籍
	private String refereePicture;		// 裁判照片
	private String refereeIntroduce;		// 裁判介绍
	private String refereeType;		// 裁判类型
	private String refereeTitle;		// 裁判头衔
	private Integer refereeLinkOrder;		// link_order
	private String type = "0";   //审查员类别(区分美容和培训)

	private String refereeSignaturePhoto;	//美容师裁判签名

	private String judgeName;	//裁判姓名（en + cn）

	private String refereeLinkOrderText;		// link_order (字符串格式)
	
	public GroomerShowReferee() {
		super();
	}

	public GroomerShowReferee(String id){
		super(id);
	}

	public String getRefereeNameCn() {
		return refereeNameCn;
	}

	public void setRefereeNameCn(String refereeNameCn) {
		this.refereeNameCn = refereeNameCn;
	}

	public String getRefereeNameEn() {
		return refereeNameEn;
	}

	public void setRefereeNameEn(String refereeNameEn) {
		this.refereeNameEn = refereeNameEn;
	}

	public String getRefereeSex() {
		return refereeSex;
	}

	public void setRefereeSex(String refereeSex) {
		this.refereeSex = refereeSex;
	}

	public String getRefereeCitizenship() {
		return refereeCitizenship;
	}

	public void setRefereeCitizenship(String refereeCitizenship) {
		this.refereeCitizenship = refereeCitizenship;
	}

	public String getRefereePicture() {
		return refereePicture;
	}

	public void setRefereePicture(String refereePicture) {
		this.refereePicture = refereePicture;
	}
	
	public String getRefereeIntroduce() {
		return refereeIntroduce;
	}

	public void setRefereeIntroduce(String refereeIntroduce) {
		this.refereeIntroduce = refereeIntroduce;
	}
	

	public String getRefereeType() {
		return refereeType;
	}

	public void setRefereeType(String refereeType) {
		this.refereeType = refereeType;
	}

	public String getRefereeTitle() {
		return refereeTitle;
	}

	public void setRefereeTitle(String refereeTitle) {
		this.refereeTitle = refereeTitle;
	}

	public Integer getRefereeLinkOrder() {
		return refereeLinkOrder;
	}

	public void setRefereeLinkOrder(Integer refereeLinkOrder) {
		this.refereeLinkOrder = refereeLinkOrder;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getRefereeSignaturePhoto() {
		return refereeSignaturePhoto;
	}

	public void setRefereeSignaturePhoto(String refereeSignaturePhoto) {
		this.refereeSignaturePhoto = refereeSignaturePhoto;
	}

	public String getJudgeName() {
		return judgeName;
	}

	public void setJudgeName(String judgeName) {
		this.judgeName = judgeName;
	}

	public String getRefereeLinkOrderText() {
		return refereeLinkOrderText;
	}

	public void setRefereeLinkOrderText(String refereeLinkOrderText) {
		this.refereeLinkOrderText = refereeLinkOrderText;
	}
}