/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.groomer.entity.InternationalGroomerCertificate;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 国际美容师管理DAO接口
 *
 * @author wangjie
 * @version 2019-07-29
 */
@MyBatisDao
public interface InternationalGroomerCertificateDao extends CrudDao<InternationalGroomerCertificate> {

	int insertCertificate(InternationalGroomerCertificate internationalGroomerCertificate);

	List<InternationalGroomerCertificate> getByMemcode(String memberCode);

	void physicsDelete(String memberCode);

	void updatePrintType(InternationalGroomerCertificate groomerCertificate);

	int selectMaxCertificateNum(@Param("certificateNumPrefix") String certificateNumPrefix);

	int countMemberCertificate(@Param("memberCode") String memberCode,
			@Param("certificateType") String certificateType);

	Map customSelectMemberEndDate(@Param("sql") String sql);

	InternationalGroomerCertificate getEntityByMemberCode(@Param("memberCode") String memberCode,
			@Param("type") String type);

}