package com.cku.oa.goods.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.goods.service.SkuItemRelService;
import com.cku.oa.goods.service.SysBusinessServiceService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.goods.entity.Sku;
import com.cku.oa.goods.service.SkuService;

import java.util.Objects;

/**
 * 商品Controller
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@Controller
@RequestMapping(value = "${adminPath}/goods/sku")
public class SkuController extends BaseController {

	@Autowired
	private SkuService skuService;
	@Autowired
	private SysBusinessServiceService sysBusinessServiceService;
	@Autowired
	private SkuItemRelService skuItemRelService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@ModelAttribute
	public Sku get(@RequestParam(required = false) String id) {
		Sku entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = skuService.get(id);
		}
		if (entity == null) {
			entity = new Sku();
		}
		return entity;
	}

	@RequiresPermissions("goods:sku:view")
	@RequestMapping(value = {"list", ""})
	public String list(Sku sku, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Sku> page = skuService.findPage(new Page<>(request, response), sku);
		model.addAttribute("page", page);
		return "oa/goods/skuList";
	}

	@RequiresPermissions("goods:sku:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(Sku sku, Model model) {
		model.addAttribute("selectItemIds", skuItemRelService.findItemIdsBySku(sku.getId()));
		model.addAttribute("itemList", paymentChargingItemService.findAllList(new PaymentChargingItem()));
		model.addAttribute("businessServiceList", sysBusinessServiceService.findAllList());
		model.addAttribute("isView", 1);
		model.addAttribute("sku", sku);
		return "oa/goods/skuForm";
	}

	@RequiresPermissions("goods:sku:edit")
	@RequestMapping(value = "editForm")
	public String editForm(Sku sku, Model model) {
		if (Objects.nonNull(sku) && StringUtils.isNotBlank(sku.getId())) {
			model.addAttribute("selectItemIds", skuItemRelService.findItemIdsBySku(sku.getId()));
		} else {
			//初始化
			sku.setSaleFlag(0);
		}
		model.addAttribute("itemList", paymentChargingItemService.findAllList(new PaymentChargingItem()));
		model.addAttribute("businessServiceList", sysBusinessServiceService.findAllList());
		model.addAttribute("isView", 0);
		model.addAttribute("sku", sku);
		return "oa/goods/skuForm";
	}

	@RequiresPermissions("goods:sku:edit")
	@RequestMapping(value = "save")
	public String save(Sku sku, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sku)) {
			return editForm(sku, model);
		}
		try {
			skuService.save(sku);
			addMessage(redirectAttributes, "保存商品成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "保存商品失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sku/?repage";
	}

	@RequiresPermissions("goods:sku:del")
	@RequestMapping(value = "delete")
	public String delete(Sku sku, RedirectAttributes redirectAttributes) {
		try {
			skuService.delete(sku);
			addMessage(redirectAttributes, "删除商品成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除商品失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/goods/sku/?repage";
	}

}