/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * SKU收费项关联Entity
 * @author yuanshuai
 * @version 2023-06-16
 */
public class SkuItemRel extends DataEntity<SkuItemRel> {
	
	private static final long serialVersionUID = 1L;
	private String skuId;		// SKUID
	private String chargingItemId;		// 收费项ID
	
	public SkuItemRel() {
		super();
	}

	public SkuItemRel(String id){
		super(id);
	}

	@Length(min=1, max=32, message="SKUID长度必须介于 1 和 32 之间")
	public String getSkuId() {
		return skuId;
	}

	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}
	
	@Length(min=1, max=32, message="收费项ID长度必须介于 1 和 32 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}
	
}