/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.User;

import lombok.AllArgsConstructor;
import lombok.Builder;

/**
 * 会员支付流水Entity
 *
 * @author lyy
 * @version 2016-07-18
 */
@Builder
@AllArgsConstructor
public class PaymentRecord extends DataEntity<PaymentRecord> {

	private static final long serialVersionUID = 1L;
	private String memberCode; // 会员号
	private String businessId; // 业务表id
	private String chargingItemId; // 付款条目，参考payment_item表。如果payment_item为空，代表账号充值
	private Integer chargingItemNum; // 付款条目数量
	private String paymentAmount; // 实付金额
	private String price; // 付款服务的价格
	private String paymentWay; // 参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等
	private String runningNumber; // 流水号
	private String paymentState; // 付款状态
	private String outTradeNo; // 支付宝返回的参数out_trade_no
	private Date paymentTime; // 支付时间
	private String paymentRemarks; // 付款备注
	private User updateByName; // update_by_name
	private String alipayS; // 支付宝的参数

	private String code; // 页面需要
	private String remarks;// 备注

	private String isInstallment;// 分摊时间段 3个月为3 不分摊为0
	private Date installmentStartDate;// 分摊开始时间
	private Date installmentEndDate;// 分摊结束时间
	private Date splitBeginDate;// 拆账程序需要
	private String showBusinessModelFlag = "0";// 赛事业务模式

	private String businessMappingId; // 财务的业务分类id
	private Date beginAddTime; // 开始 添加时间
	private Date endAddTime; // 结束 添加时间
	private String isRecharge;// 是否充值订单：0否；1是,默认为0
	private String totalPrice; // 总价

	private String registerProvince;
	private String registerCity;
	private String bizMemberCode;
	private String queryMemberCode;
	

	public String getBusinessMappingId() {
		return businessMappingId;
	}

	public void setBusinessMappingId(String businessMappingId) {
		this.businessMappingId = businessMappingId;
	}

	public Date getSplitBeginDate() {
		return splitBeginDate;
	}

	public void setSplitBeginDate(Date splitBeginDate) {
		this.splitBeginDate = splitBeginDate;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	private PaymentChargingItem paymentChargingItem;

	public PaymentChargingItem getPaymentChargingItem() {
		return paymentChargingItem;
	}

	public void setPaymentChargingItem(PaymentChargingItem paymentChargingItem) {
		this.paymentChargingItem = paymentChargingItem;
	}

	public PaymentRecord() {
		super();
	}

	public PaymentRecord(String id) {
		super(id);
	}

	@Length(min = 0, max = 60, message = "会员号长度必须介于 0 和 60 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "业务表id长度必须介于 0 和 64 之间")
	public String getBusinessId() {
		return businessId;
	}

	public void setBusinessId(String businessId) {
		this.businessId = businessId;
	}

	@Length(min = 0, max = 64, message = "付款条目，参考payment_item表。如果payment_item为空，代表账号充值长度必须介于 0 和 64 之间")
	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	public Integer getChargingItemNum() {
		return chargingItemNum;
	}

	public void setChargingItemNum(Integer chargingItemNum) {
		this.chargingItemNum = chargingItemNum;
	}

	public String getPaymentAmount() {
		return paymentAmount;
	}

	public void setPaymentAmount(String paymentAmount) {
		this.paymentAmount = paymentAmount;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 64, message = "参见数据字典表：代表的是支付宝充值，赛场收费，建行网银充值等长度必须介于 0 和 64 之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@Length(min = 0, max = 50, message = "支付宝返回的参数out_trade_no长度必须介于 0 和 50 之间")
	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min = 0, max = 255, message = "付款备注长度必须介于 0 和 255 之间")
	public String getPaymentRemarks() {
		return paymentRemarks;
	}

	public void setPaymentRemarks(String paymentRemarks) {
		this.paymentRemarks = paymentRemarks;
	}

	public User getUpdateByName() {
		return updateByName;
	}

	public void setUpdateByName(User updateByName) {
		this.updateByName = updateByName;
	}

	@Length(min = 0, max = 100, message = "支付宝的参数长度必须介于 0 和 100 之间")
	public String getAlipayS() {
		return alipayS;
	}

	public void setAlipayS(String alipayS) {
		this.alipayS = alipayS;
	}

	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	@Length(min = 0, max = 10, message = "分摊时间段 3个月为3 不分摊为0")
	public String getIsInstallment() {
		return isInstallment;
	}

	public void setIsInstallment(String isInstallment) {
		this.isInstallment = isInstallment;
	}

	public Date getInstallmentStartDate() {
		return installmentStartDate;
	}

	public void setInstallmentStartDate(Date installmentStartDate) {
		this.installmentStartDate = installmentStartDate;
	}

	public Date getInstallmentEndDate() {
		return installmentEndDate;
	}

	public void setInstallmentEndDate(Date installmentEndDate) {
		this.installmentEndDate = installmentEndDate;
	}

	public String getShowBusinessModelFlag() {
		return showBusinessModelFlag;
	}

	public void setShowBusinessModelFlag(String showBusinessModelFlag) {
		this.showBusinessModelFlag = showBusinessModelFlag;
	}

	public Date getBeginAddTime() {
		return beginAddTime;
	}

	public void setBeginAddTime(Date beginAddTime) {
		this.beginAddTime = beginAddTime;
	}

	public Date getEndAddTime() {
		return endAddTime;
	}

	public void setEndAddTime(Date endAddTime) {
		this.endAddTime = endAddTime;
	}

	public String getIsRecharge() {
		return isRecharge;
	}

	public void setIsRecharge(String isRecharge) {
		this.isRecharge = isRecharge;
	}

	public String getTotalPrice() {
		return totalPrice;
	}

	public void setTotalPrice(String totalPrice) {
		this.totalPrice = totalPrice;
	}

	@Override
	public String toString() {
		return "PaymentRecord [memberCode=" + memberCode + ", businessId=" + businessId + ", chargingItemId="
				+ chargingItemId + ", chargingItemNum=" + chargingItemNum + ", paymentAmount=" + paymentAmount
				+ ", price=" + price + ", paymentWay=" + paymentWay + ", runningNumber=" + runningNumber
				+ ", paymentState=" + paymentState + ", outTradeNo=" + outTradeNo + ", paymentTime=" + paymentTime
				+ ", paymentRemarks=" + paymentRemarks + ", updateByName=" + updateByName + ", alipayS=" + alipayS
				+ ", code=" + code + ", remarks=" + remarks + ", isInstallment=" + isInstallment
				+ ", installmentStartDate=" + installmentStartDate + ", installmentEndDate=" + installmentEndDate
				+ ", splitBeginDate=" + splitBeginDate + ", showBusinessModelFlag=" + showBusinessModelFlag
				+ ", businessMappingId=" + businessMappingId + ", beginAddTime=" + beginAddTime + ", endAddTime="
				+ endAddTime + ", isRecharge=" + isRecharge + ", totalPrice=" + totalPrice + ", paymentChargingItem="
				+ paymentChargingItem + "]";
	}

	public String getRegisterProvince() {
		return registerProvince;
	}

	public void setRegisterProvince(String registerProvince) {
		this.registerProvince = registerProvince;
	}

	public String getRegisterCity() {
		return registerCity;
	}

	public void setRegisterCity(String registerCity) {
		this.registerCity = registerCity;
	}

	public String getBizMemberCode() {
		return bizMemberCode;
	}

	public void setBizMemberCode(String bizMemberCode) {
		this.bizMemberCode = bizMemberCode;
	}

	public String getQueryMemberCode() {
		return queryMemberCode;
	}

	public void setQueryMemberCode(String queryMemberCode) {
		this.queryMemberCode = queryMemberCode;
	}

}