package com.cku.oa.finance.cab.dao;

import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 宠爱王国业务扣费查询统计
 * @author xuzhenxing
 *
 */
@MyBatisDao

public interface CABFinanceStatisticsDao {


	/**
	 * 业务扣费
	 */

	/**
	 * 所有在CAB及CKU收费项目中原始的扣费项目、数量、金额
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	List<Map> totalCharge(@Param("startDate")String startDate,@Param("endDate")String endDate);

	List<Map> charge(@Param("startDate")String startDate,@Param("endDate")String endDate);

	/**
	 * CAB部门名称
	 * @order soft
	 * @return id office的ID
	 * @return name office的名称
	 */
	List<Map> officeCAB();

	/**
	 * CKU部门名称
	 * @order soft
	 * @return id office的ID
	 * @return name office的名称
	 */
	List<Map> officeCKU();

	List<Map> relationShip();
	HashMap<String, String> relationShipById(@Param("id") String id);
	HashMap<String, String> relationShipGetById(@Param("id") String id);
	String ckuChargeItemPriceById(@Param("id") String id);
	String cabChargeItemPriceById(@Param("id") String id);
	List<Map> ckuChargeItem();
	List<Map> cabChargeItem();
	List<Map> ckuChargeItemPriceGetById(@Param("id") String id);
	List<Map> cabChargeItemPriceGetById(@Param("id") String id);


	List<Map> ckuChargeItemPriceGetByIdList(@Param("ids") List<String> ids);
	List<Map> cabChargeItemPriceGetByIdList(@Param("ids") List<String> ids);

	/**
	 * csv拆帐部分用到的
	 * @return
	 */
	List<Map> officeCSV_CAB();

	List<Map> officeCSV();

}
