/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.dao.DogNoseDao;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.service.DogNoseService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬只信息管理Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "${adminPath}/dogNose")
public class DogNoseController extends BaseController {

	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogNoseDao dogNoseDao;

	@ModelAttribute
	public DogNose get(@RequestParam(required = false) String id) {
		DogNose entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogNoseService.get(id);
		}
		if (entity == null) {
			entity = new DogNose();
		}
		return entity;
	}

	@RequiresPermissions("dog:dogNose:view")
	@RequestMapping(value = { "list", "" })
	public String list(DogNose dogNose, HttpServletRequest request, HttpServletResponse response, Model model) {
		dogNose.setDelFlag(null);
		Page<DogNose> page = dogNoseService.findPage(new Page<DogNose>(request, response), dogNose);
		model.addAttribute("page", page);
		return "oa/dog/dogNose/dogNoseList";
	}

	@RequiresPermissions("dog:dogNose:edit")
	@RequestMapping(value = "edit")
	public String edit(HttpServletRequest request, Model model) {
		String id = request.getParameter("id");
		DogNose dogNose = new DogNose();
		dogNose.setId(id);
		List<DogNose> list = dogNoseService.findList(dogNose);
		model.addAttribute("dogNose", list.get(0));
		return "oa/dog/dogNose/dogNoseEdit";
	}

	@RequiresPermissions("dog:dogNose:edit")
	@RequestMapping(value = "save")
	public String save(HttpServletRequest request, Model model, RedirectAttributes redirectAttributes) {
		String id = request.getParameter("id");
		String delFlag = request.getParameter("delFlag");
		String remarks = request.getParameter("remarks");
		DogNose dogNose = new DogNose();
		dogNose.setId(id);
		dogNose.setRemarks(remarks);
		dogNose.setDelFlag(delFlag);
		dogNoseDao.updateDel(dogNose);
		addMessage(redirectAttributes, "保存鼻纹状态成功");
		return "redirect:" + Global.getAdminPath() + "/dogNose/list/?repage";
	}

	@RequiresPermissions("dog:dogNose:edit")
	@RequestMapping(value = "from")
	public String form(HttpServletRequest request, Model model) {
		String id = request.getParameter("id");
		DogNose dogNose = new DogNose();
		dogNose.setId(id);
		List<DogNose> list = dogNoseService.findList(dogNose);
		model.addAttribute("dogNose", list.get(0));
		return "oa/dog/dogNose/dogNoseFrom";
	}

}