/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.dog.entity.Dog;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬只鉴定表Controller
 * @author lgl
 * @version 2016-08-09
 */
@Controller
@RequestMapping(value = "${adminPath}/dogappraisal/dogAppraisal")
public class DogAppraisalController extends BaseController {

	@Autowired
	private DogAppraisalService dogAppraisalService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private OrgDao orgDao;

	private final static String REPAGE = "redirect:"+Global.getAdminPath()+"/dogappraisal/dogAppraisal/?repage";
	
	private final static String AUTHORITY_PRDFIX = "dogappraisal:dogAppraisal:";
	
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required=true)String runningNumber,
			@RequestParam(required=true)String chargingItemId,
			@RequestParam(required=true)String memberCode,
			Model model) {
		DogAppraisal dogAppraisal = new DogAppraisal(runningNumber,chargingItemId,memberCode);
		model.addAttribute("dogAppraisal", dogAppraisal);
		//只有fci正式品种和原生犬（NB-）可以申请
		model.addAttribute("dogTypeList", dogTypeService.findFormalAndNBList());
		Org org=new Org();
		org.setState("0");
		org.setOrgType("club");;
		model.addAttribute("orgList", orgDao.findList(org));
		//最近结束的20场主赛事
		List<MainShows> mainShowsList = mainShowsDao.getLatestEnd();
		model.addAttribute("mainShowsList", mainShowsList);
		if("20".equals(chargingItemId)||"125".equals(chargingItemId)){
			model.addAttribute("identifyType", 1);
			dogAppraisal.setIdentifyType("1");
		}else if("316".equals(chargingItemId)||"14".equals(chargingItemId)||"131".equals(chargingItemId)||"238".equals(chargingItemId)){
			//如果收费项为宠爱犬鉴定服务费，鉴定类型为检查员鉴定
			dogAppraisal.setIdentifyType("0");
		}
		return "oa/dog/dogappraisal/dogAppraisalOrderAdd";
	}
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogAppraisal dogAppraisal, Model model) {
		List<DogAppraisal> list = dogAppraisalService.findList(dogAppraisal);
		model.addAttribute("list", list);
		return "oa/dog/dogappraisal/dogAppraisalOrderList";
	}
	
	@ModelAttribute
	public DogAppraisal get(@RequestParam(required=false) String id) {
		DogAppraisal entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogAppraisalService.get(id);
		}
		if (entity == null){
			entity = new DogAppraisal();
		}
		//标记isFinishOrder字段
		entity.setIsFinishOrder(dogAppraisalService.getIsFinishOrder(entity));
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(DogAppraisal dogAppraisal, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogAppraisal> page = dogAppraisalService.findPage(new Page<DogAppraisal>(request, response), dogAppraisal);
		//标记isFinishOrder字段
		for(DogAppraisal po:page.getList()){
			po.setIsFinishOrder(dogAppraisalService.getIsFinishOrder(po));
			po.setBusinessState(dogAppraisalService.getBusinessState(po));
		}
		
		List<DogAppraisal> list = page.getList();
		for(DogAppraisal appraisal:list) {
			String runningNumber = appraisal.getRunningNumber();
			if (StringUtils.isNotBlank(runningNumber)) {
				//查询订单详情是否在退款中或审核通过  不可操作业务
				PaymentOrderDetail byOrderCode = paymentOrderDetailDao.getByOrderCode(runningNumber);
				if (byOrderCode != null && ("3".equals(byOrderCode.getBusinessRefundState()) || "1".equals(byOrderCode.getBusinessRefundState()))) {
					appraisal.setBusinessRefundState(byOrderCode.getBusinessRefundState());
				}
			}
		}
		model.addAttribute("page", page);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		if("230".equals(dogAppraisal.getDogBreed())){
			return "oa/dog/dogappraisal/dogAppraisalListZangao";
		}
		return "oa/dog/dogappraisal/dogAppraisalList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(DogAppraisal dogAppraisal, Model model) {
		model.addAttribute("dogAppraisal", dogAppraisal);
		return "oa/dog/dogappraisal/dogAppraisalAuditForm";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = "form")
	public String form(DogAppraisal dogAppraisal, Model model) {
		model.addAttribute("dogAppraisal", dogAppraisal);
		return "oa/dog/dogappraisal/dogAppraisalForm";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogAppraisal dogAppraisal, Model model) {
		model.addAttribute("dogAppraisal", dogAppraisal);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		model.addAttribute("dogColorMarkList", dogColorMarkService.getByDogBreedCode(dogAppraisal.getDogBreed()));
		return "oa/dog/dogappraisal/dogAppraisalEditForm";
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "dogAppraisalApply")
	public String dogAppraisalApply(DogAppraisal dogAppraisal, Model model) {
		model.addAttribute("dogAppraisal", dogAppraisal);
		model.addAttribute("dogTypeList", dogTypeService.findAllList());
		model.addAttribute("dogColorMarkList", dogColorMarkService.getByDogBreedCode(dogAppraisal.getDogBreed()));
		return "oa/dog/dogappraisal/dogAppraisalApply";
	}
	
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogAppraisal dogAppraisal) {
		HashMap<String,String> map = new HashMap<String,String>();
		map.put("rc", "0");
		try {
			dogAppraisalService.add(dogAppraisal);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "edit")
	public String edit(DogAppraisal dogAppraisal, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogAppraisal)){
			return editForm(dogAppraisal, model);
		}
		dogAppraisalService.edit(dogAppraisal);
		addMessage(redirectAttributes, "编辑犬只鉴定成功");
		return repage(dogAppraisal);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"delete")
	@RequestMapping(value = "delete")
	public String delete(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
		try {
			dogAppraisalService.delete(dogAppraisal);
			addMessage(redirectAttributes, "删除犬只鉴定成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除犬只鉴定失败："+e.getMessage());
		}
		return repage(dogAppraisal);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"audit")
	@RequestMapping(value = "audit")
	public String audit(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "审核犬只鉴定成功");
		try {
			dogAppraisalService.audit(dogAppraisal);
		} catch (Exception e) {
			logger.warn("审核犬只鉴定失败",e);
			addMessage(redirectAttributes, "审核犬只鉴定失败:"+e.getMessage());
		}
		return repage(dogAppraisal);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"resolve")
	@RequestMapping(value = "resolve")
	public String resolve(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "处理犬只鉴定成功");
		try {
			dogAppraisalService.resolve(dogAppraisal);
		} catch (Exception e) {
			logger.warn("处理犬只鉴定失败：",e);
			addMessage(redirectAttributes, "处理犬只鉴定失败："+e.getMessage());
		}
		return repage(dogAppraisal);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"print")
	@RequestMapping(value = "print")
	public String print(DogAppraisal print, Model model) {
		return dogAppraisalService.print(print,model);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"resetPrint")
	@RequestMapping(value = "resetPrint")
	public String resetPrint(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
		dogAppraisalService.resetPrint(dogAppraisal);
		addMessage(redirectAttributes, "重置犬只鉴定打印成功");
		return repage(dogAppraisal);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"print")
	@RequestMapping(value = "printDna")
	public String printDna(DogAppraisal dogAppraisal, Model model) {
		return dogAppraisalService.printDna(dogAppraisal,model);
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"resetPrint")
	@RequestMapping(value = "resetPrintDna")
	public String resetPrintDna(DogAppraisal dogAppraisal, RedirectAttributes redirectAttributes) {
		dogAppraisalService.resetPrintDna(dogAppraisal);
		addMessage(redirectAttributes, "重置犬只DNA鉴定打印成功");
		return repage(dogAppraisal);
	}

	/**
	 * 
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogAppraisal dogAppraisal){
		if("230".equals(dogAppraisal.getDogBreed())){
			return REPAGE+"&dogBreed=230";
		}
		return REPAGE;
	}

	/**
	 *
	 * @Description：赛场鉴定编号有效性查询
	 * @author: zhuoHeng
	 * @version: 2016年10月14日 下午4:51:48
	 */
	@RequestMapping(value = "getMessageByShowAppraisalCode")
	@ResponseBody
	public Object getMessageByShowAppraisalCode(String showAppraisalCode){
		HashMap<String,String> map = dogAppraisalService.getMessageByBirthCerRegCode(showAppraisalCode);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByShowAppraisalCode")
	@ResponseBody
	public Object getDogByShowAppraisalCode(@RequestParam(required=true)String showAppraisalCode) {
		HashMap<String,String> map = dogAppraisalService.getDogByShowAppraisalCode(showAppraisalCode);
		return map;
	}
}