package com.cku.oa.dog.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogPedigreeCertifiedChangeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.partner.club.service.ClubDogChipDeleteService;
import com.cku.restful.v1.dog.vo.DogBloodCheckVO;
import com.cku.restful.v1.finance.service.OADeleteService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * DNA血样留存Service
 *
 * @author lgl
 * @version 2016-11-24
 */
@Service
@Transactional(readOnly = true)
public class DogBloodSaveService extends CrudService<DogBloodSaveDao, DogBloodSave> {

	@Autowired
	private OADeleteService oADeleteService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private ClubDogChipDeleteService clubDogChipDeleteService;
	@Autowired
	private DogPedigreeCertifiedChangeDao dogPedigreeCertifiedChangeDao;
	@Autowired
	private DogAppraisalDao dogAppraisalDao;
	@Autowired
	private LoginServerService loginServerService;
	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	private DogBloodSaveDao dogBloodSaveDao;

	public DogBloodSave get(String id) {
		return super.get(id);
	}

	public List<DogBloodSave> findList(DogBloodSave dogBloodSave) {
		if (StringUtils.isBlank(dogBloodSave.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogBloodSave.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogBloodSave.getSqlMap().put("dogBreedMap", " ='" + dogBloodSave.getDogBreed() + "'");
		}
		return super.findList(dogBloodSave);
	}

	public Page<DogBloodSave> findPage(Page<DogBloodSave> page, DogBloodSave dogBloodSave) {
		if (StringUtils.isBlank(dogBloodSave.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogBloodSave.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogBloodSave.getSqlMap().put("dogBreedMap", " ='" + dogBloodSave.getDogBreed() + "'");
		}
		return super.findPage(page, dogBloodSave);
	}

	public Page<DogBloodSave> findPage1(Page<DogBloodSave> page, DogBloodSave dogBloodSave) {
		if (StringUtils.isBlank(dogBloodSave.getDogBreed())) {
			// 根据当前登录端查询犬种
			dogBloodSave.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			dogBloodSave.getSqlMap().put("dogBreedMap", " ='" + dogBloodSave.getDogBreed() + "'");
		}
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		dogBloodSave.setPage(page);
		List<DogBloodSave> list = dogBloodSaveDao.findList1(dogBloodSave);
		// 查询犬主
		List<String> birthCodes = new ArrayList<>();
		List<String> showAppraisalCodes = new ArrayList<>();
		List<String> pedigreeCertifieds = new ArrayList<>();
		for (DogBloodSave d : list) {
			if (!StringUtils.isEmpty(d.getBirthCode())) {
				birthCodes.add(d.getBirthCode());
			}
			if (!StringUtils.isEmpty(d.getPedigreeCertified())) {
				pedigreeCertifieds.add(d.getPedigreeCertified());
			}
			if (!StringUtils.isEmpty(d.getShowAppraisalCode())) {
				showAppraisalCodes.add(d.getShowAppraisalCode());
			}
		}
		List<Dog> birthCodeNames = new ArrayList<>();
		List<Dog> pedigreeCertifiedNames = new ArrayList<>();
		List<DogAppraisal> showAppraisalNames = new ArrayList<>();
		if (!CollectionUtils.isEmpty(birthCodes)) {
			birthCodeNames = dogService.findDogNameByBirthCode(birthCodes);
		}
		if (!CollectionUtils.isEmpty(pedigreeCertifieds)) {
			pedigreeCertifiedNames = dogService.findDogNameByPedigreeCode(pedigreeCertifieds);
		}
		if (!CollectionUtils.isEmpty(showAppraisalCodes)) {
			showAppraisalNames = dogAppraisalDao.findDogName(showAppraisalCodes);
		}
		for (DogBloodSave d : list) {
			for (Dog dogname : birthCodeNames) {
				if (dogname.getBirthCertificateLevelCode().equals(d.getBirthCode())) {
					d.setName(dogname.getNameCn());
				}
			}
			for (Dog dogname : pedigreeCertifiedNames) {
				if (dogname.getPedigreeCertifiedCode().equals(d.getPedigreeCertified())) {
					d.setName(dogname.getNameCn());
				}
			}
			for (DogAppraisal dogname : showAppraisalNames) {
				if (dogname.getShowAppraisalCode().equals(d.getShowAppraisalCode())) {
					d.setName(dogname.getDogOwnerName());
				}
			}
		}

		page.setList(list);
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<DogBloodSave>(0));
		}
		return page;
	}

	@Transactional(readOnly = false)
	public void save(DogBloodSave dogBloodSave) {
		super.save(dogBloodSave);
	}

	@Transactional(readOnly = false)
	public void delete(DogBloodSave dogBloodSave) {
		// 已缴费的订单不允许删除
		if ("2".equals(dogBloodSave.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已缴费，不允许删除");
		}
		// OA删除订单
		oADeleteService.deleteUnpay(dogBloodSave.getPaymentState(), "dog_blood_save", dogBloodSave.getId(),
				dogBloodSave.getRunningNumber());
		// 如果是oa报名的话，没有订单，故没走上面的删除，所以需要再次删除
		super.delete(dogBloodSave);
		// 地方俱乐部未交费订单删除
		clubDogChipDeleteService.deleteUnpayDogChipBusiness(dogBloodSave.getBirthCode());
	}

	/**
	 *
	 * @description: 保存血样留存申请
	 * @author: laiguanglong
	 * @date: 2016年8月24日 下午4:08:43
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void add(DogBloodSave add) throws ZAException {
		if (StringUtils.isBlank(add.getBirthCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入血统证书号或出生纸编号或赛场鉴定编号或外国血统证书号");
		}
		if ("0".equals(add.getType())) {
			add.setPedigreeCertified(add.getBirthCode());
			add.setBirthCode("");
		} else if ("2".equals(add.getType())) {
			add.setShowAppraisalCode(add.getBirthCode());
			add.setBirthCode("");
		} else if ("3".equals(add.getType())) {
			add.setOverseasPedigreeCertified(add.getBirthCode());
			add.setBirthCode("");
		}
		DogBloodSave dogBloodSave = new DogBloodSave();
		if (StringUtils.isNotBlank(add.getPedigreeCertified()) || StringUtils.isNotBlank(add.getBirthCode())) {
			// 根据血统证书号（犬只DNA存档）或根据出生纸编号（新生犬登记）的订单录入
			Dog dog = null;
			DogBirthCertificate dogBirthCertificate = null;
			if (StringUtils.isNotBlank(add.getPedigreeCertified())) {
				dog = dogService.getByPedigreeCertifiedCode(add.getPedigreeCertified());
				if (dog == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
				}
				// 0根据出生纸编号查重
				if (dao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode()) != null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已有DNA血样留存业务记录");
				}
				DogAppraisal dogAppraisal = dogAppraisalDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (dogAppraisal != null) {
					dogBloodSave.setShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
				}
				dogBloodSave.setBirthCode(dog.getBirthCertificateLevelCode());
				dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
				dogBloodSave.setOverseasPedigreeCertified(dog.getPedigreeCertifiedEn());
			}
			if (StringUtils.isNotBlank(add.getBirthCode())) {
				dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(add.getBirthCode());
				if (dogBirthCertificate == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生纸编号有误");
				}
				// 0根据出生纸编号查重
				if (dao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode()) != null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已有DNA血样留存业务记录");
				}
				dogBloodSave.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
				dogBloodSave.setPedigreeCertified(dogBirthCertificate.getPedigreeCertified());
			}
			if (dog != null && dogBirthCertificate != null
					&& !dog.getBirthCertificateLevelCode().equals(dogBirthCertificate.getBirthCerRegCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书号与出生纸编号不匹配，请检查");
			}
		}
		if (StringUtils.isNotBlank(add.getShowAppraisalCode())) {// 根据赛场鉴定编号（赛场犬只鉴定）的订单录入
			// 校验赛场鉴定编号
			DogAppraisal dogAppraisal = dogAppraisalDao.getByShowAppraisalCode(add.getShowAppraisalCode());
			if (dogAppraisal == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "赛场鉴定编号有误");
			}
			dogAppraisal.setShowAppraisalOrderRunningNumber(add.getRunningNumber());
			dogAppraisalDao.update(dogAppraisal);
			dogBloodSave.setShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
			dogBloodSave.setPedigreeCertified(dogAppraisal.getPedigreeCertified());
			dogBloodSave.setOverseasPedigreeCertified(dogAppraisal.getPedigreeCertifiedEn());
			// 2赛场鉴定记录付款会员号与订单会员号一致
			if (!dogAppraisal.getPaymentMemberCode().equals(add.getPaymentMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该赛场鉴定记录的付款人会员号与订单会员号不一致，请检查");
			}
		}
		if (StringUtils.isNotBlank(add.getOverseasPedigreeCertified())) {// 根据外国血统证书号（证书换发）的订单录入
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao
					.getByPedigreeCertified(add.getOverseasPedigreeCertified());
			if (dogPedigreeCertifiedChange == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "外国血统证书号有误");
			}
			dogBloodSave.setOverseasPedigreeCertified(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		}
		dogBloodSave.setPaymentMemberCode(add.getPaymentMemberCode());
		// oa订单录入价格取收费项详情中的实收价格
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.getOrderByRunningNum(add.getRunningNumber(),
				add.getPaymentMemberCode());
		PaymentOrderDetail paymentOrderDetail = null;
		for (PaymentOrderDetail orderDetail : orderDetailList) {
			if (add.getPaymentChargingItemId().equals(orderDetail.getChargingItemId())) {
				paymentOrderDetail = orderDetail;
				break;
			}
		}
		dogBloodSave.setPrice(paymentOrderDetail.getPrice());
		dogBloodSave.setRunningNumber(add.getRunningNumber());
		dogBloodSave.setPaymentState("2");
		dogBloodSave.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(add.getRunningNumber()));
		dogBloodSave.setIsCanceled("0");
		dogBloodSave.setOrgId(add.getOrgId());
		super.save(dogBloodSave);
		for (PaymentOrderDetail data : orderDetailList) {
			if (StringUtils.isBlank(data.getBusinessIds())) {
				data.setBusinessIds(dogBloodSave.getId());
				data.setBusinessTable("dog_blood_save");
				paymentOrderDetailDao.update(data);
				break;
			}
		}
	}

	public String editForm(DogBloodSave dogBloodSave, Model model) {
		String pedigreeCertified = "";
		String dogName = "";
		Date dogBirthday = null;
		String dogGender = "";
		Dog dog = null;
		if (StringUtils.isNotBlank(dogBloodSave.getBirthCode())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
					.getByBirthCerRegCode(dogBloodSave.getBirthCode());
			dogName = dogBirthCertificate.getDogEnName();
			dogBirthday = dogBirthCertificate.getDogBirthday();
			dogGender = dogBirthCertificate.getDogGender();
			dog = dogService.getByBirthCertificateLevelCode(dogBloodSave.getBirthCode());
		} else if (StringUtils.isNotBlank(dogBloodSave.getOverseasPedigreeCertified())) {
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao
					.getByOverseasPedigreeCertified(dogBloodSave.getOverseasPedigreeCertified());
			dogName = dogPedigreeCertifiedChange.getDogName();
			dogBirthday = dogPedigreeCertifiedChange.getDogBirthday();
			dogGender = dogPedigreeCertifiedChange.getDogGender();
			dog = dogService.getByPedigreeCertifiedEn(dogBloodSave.getOverseasPedigreeCertified());
		} else if (StringUtils.isNotBlank(dogBloodSave.getShowAppraisalCode())) {
			DogAppraisal dogAppraisal = dogAppraisalDao.getByShowAppraisalCode(dogBloodSave.getShowAppraisalCode());
			dogName = dogAppraisal.getDogName();
			dogBirthday = dogAppraisal.getBirthday();
			dogGender = dogAppraisal.getDogGender();
			pedigreeCertified = dogAppraisal.getPedigreeCertified();
		}
		if (dog != null) {
			pedigreeCertified = dog.getPedigreeCertifiedCode();
		}
		dogBloodSave.setPedigreeCertified(pedigreeCertified);
		dogBloodSave.setDogName(dogName);
		dogBloodSave.setDogBirthday(dogBirthday);
		dogBloodSave.setDogGender(dogGender);
		model.addAttribute("dogBloodSave", dogBloodSave);
		return "oa/dog/dogbloodsave/dogBloodSaveEditForm";
	}

	/**
	 * 根据证书号查询
	 * 
	 * @author yuanshuai
	 * @date 2023/7/14 13:26
	 */
	public DogBloodSave getByPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号为空");
		}
		return dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
	}

	public DogBloodSave getByBirthCode(String birthCode) {
		return dao.getByBirthCode(birthCode);
	}

	/**
	 * 根据国外证书号查询血样记录
	 *
	 * @Author chaixueteng
	 * @2017年9月7日上午11:35:05
	 */
	public DogBloodSave getByOverPedigreeCode(String overPeidgreeCode) {
		return dao.getByOverPedigreeCode(overPeidgreeCode);
	}

	/**
	 * @Description： 根据赛场鉴定编号查询
	 *
	 * @author: yuanshuai
	 * @date: 2018/9/28 10:57
	 */
	public DogBloodSave getByShowAppraisalCode(String showAppraisalCode) {
		return dao.getByShowAppraisalCode(showAppraisalCode);
	}

	public DogBloodSave getByParams(DogBloodSave s, Boolean isCheckUnpaid) {
		return dao.getByParams(s, isCheckUnpaid);
	}

	public DogBloodSave getByParams2(DogBloodSave s, Boolean isCheckUnpaid) {
		return dao.getByParams2(s, isCheckUnpaid);
	}

	@SuppressWarnings("deprecation")
	private Date CHECK_DATE = new Date(2017 - 1900, 6 - 1, 1, 0, 0);

	/**
	 * 校验有没有血样留存记录
	 *
	 * @param keyword       证书号或芯片号
	 * @param isCheckUnpaid 是否校验未缴费
	 * @return
	 */
	public DogBloodCheckVO check(String keyword, Boolean isCheckUnpaid) {
		if (StringUtils.isBlank(keyword)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或者芯片号不能为空");
		}
		Dog dog = dogService.getOneByIdentificationFlagOrPedigreeCertified(keyword);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号或芯片号不正确");
		}
		// 血统证书号对应订单缴费时间为2017年6月1日前的犬只不验证血样留存条件
		String runningNumber = dao.getRunningNumber(dog.getPedigreeCertifiedCode(), dog.getPedigreeCertifiedEn());
		Date paymentTime = null;
		if (StringUtils.isNotBlank(runningNumber)) {
			PaymentOrder order = paymentOrderService.getByOrderCode(runningNumber);
			if (order != null && order.getPaymentTime() != null) {
				paymentTime = order.getPaymentTime();
			}
		}
		if (paymentTime == null) {
			paymentTime = dog.getCreateDate();
		}
		if (paymentTime.before(CHECK_DATE)) {
			DogBloodCheckVO vo = new DogBloodCheckVO();
			// 是不是有血样留存
			vo.setDogDloodDna(true);
			// 是不是自己的
			vo.setMine(UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()));
			return vo;
		}

		// birth_code 登记卡号
		// show_appraisal_code 场外鉴定号
		// overseas_pedigree_certified 国外血统证书号
		DogBloodSave dogBloodSave = new DogBloodSave();
		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.setDogId(dog.getId());
		if (StringUtils.isNotBlank(dog.getBirthCertificateLevelCode())) {
			dogBloodSave.setBirthCode(dog.getBirthCertificateLevelCode());
			dogDnaArchive.setBirthCode(dog.getBirthCertificateLevelCode());
		} else {
			DogPedigreeCertifiedChange c = dogPedigreeCertifiedChangeDao.getByDogIdOrDogChip(dog.getId(),
					dog.getIdentificationFlag());
			if (c != null) {
				dogBloodSave.setOverseasPedigreeCertified(c.getOverseasPedigreeCertified());
				dogDnaArchive.setOverseasPedigreeCertified(c.getOverseasPedigreeCertified());
			} else {
				DogAppraisal da = dogAppraisalDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (da != null) {
					dogBloodSave.setShowAppraisalCode(da.getShowAppraisalCode());
				} else {
					dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
					dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
				}
			}
		}

		if (!StringUtils.isEmpty(dog.getPedigreeCertifiedCode())) {
			dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		}

		// 提交订单的时候，有未缴费的记录也不允许提交
		DogBloodSave s = getByParams(dogBloodSave, isCheckUnpaid);
		DogDnaArchive a = dogDnaArchiveDao.getByParams(dogDnaArchive, isCheckUnpaid);
		DogBloodCheckVO vo = new DogBloodCheckVO();
		vo.setDogDloodDna(s != null || a != null);// 是不是有血样留存
		vo.setMine(UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()));// 是不是自己的
		return vo;
	}

	/**
	 * 校验有没有DNA位点分析记录
	 * 
	 * @param keyword       证书号或芯片号
	 * @param isCheckUnpaid 是否校验未缴费
	 * @return
	 */
	public DogBloodCheckVO checkDna(String keyword, Boolean isCheckUnpaid) {
		if (StringUtils.isBlank(keyword)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或者芯片号不能为空");
		}
		Dog dog = dogService.getOneByIdentificationFlagOrPedigreeCertified(keyword);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号或芯片号不正确");
		}
		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.setDogId(dog.getId());
		if (StringUtils.isNotBlank(dog.getBirthCertificateLevelCode())) {
			dogDnaArchive.setBirthCode(dog.getBirthCertificateLevelCode());
		} else {
			DogPedigreeCertifiedChange c = dogPedigreeCertifiedChangeDao.getByDogIdOrDogChip(dog.getId(),
					dog.getIdentificationFlag());
			if (c != null) {
				dogDnaArchive.setOverseasPedigreeCertified(c.getOverseasPedigreeCertified());
			} else {
				dogDnaArchive.setPedigreeCertified(dog.getPedigreeCertifiedCode());
			}
		}
		// 提交订单的时候，有未缴费的记录也不允许提交
		DogDnaArchive a = dogDnaArchiveDao.getByParams(dogDnaArchive, isCheckUnpaid);
		DogBloodCheckVO vo = new DogBloodCheckVO();
		vo.setDogDloodDna(a != null);// 是不是有DNA存档
		vo.setMine(UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()));// 是不是自己的
		return vo;
	}

	public Page<DogBloodSave> findPageAll(Page<DogBloodSave> page, DogBloodSave dogBloodSave) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		dogBloodSave.setPage(page);
		page.setList(dao.getListDogDnaAndBload(dogBloodSave));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<DogBloodSave>(0));
		}
		return page;
	}

	// public List<DogDnaArchive> getList(List<DogBloodSave>
	// listDogDnaAndBload,String ttttype){
	// //将DogBloodSave封装成DogDnaArchive对象
	// List<DogDnaArchive> list = new ArrayList<>();
	//
	//
	// for(DogBloodSave dogBloodSave2 : listDogDnaAndBload ){
	// //返回
	// DogDnaArchive dogDnaArchive = new DogDnaArchive();
	//
	// //参数
	// DogDnaArchive dogDnaArchive2 = new DogDnaArchive();
	// //dogDnaArchive2.setCreateBy(UserUtils.getUser());
	// //根据证书号查询
	// if(StringUtils.isNotBlank(dogBloodSave2.getPedigreeCertified())){
	// dogDnaArchive2.setPedigreeCertified(dogBloodSave2.getPedigreeCertified());
	// dogDnaArchive = dogDnaArchiveDao.getBirthCodeAndPed(dogDnaArchive2);
	// }
	// //根据出生纸查询
	// if(dogDnaArchive==null || dogDnaArchive.getId()==null){
	// dogDnaArchive2.setPedigreeCertified(null);
	// dogDnaArchive2.setBirthCode(dogBloodSave2.getBirthCode());
	// dogDnaArchive = dogDnaArchiveDao.getBirthCodeAndPed(dogDnaArchive2);
	// }
	// //全查
	// if(StringUtils.isBlank(ttttype)){
	// if(dogDnaArchive==null || dogDnaArchive.getId()==null){
	// test(list,dogDnaArchive,dogBloodSave2);
	// }else{
	// dogDnaArchive.setType("1");//位点分析
	// list.add(dogDnaArchive);
	// }
	// }
	// //只查询位点分析
	// if(StringUtils.isNotBlank(ttttype) && ttttype.equals("1")){
	// if(dogDnaArchive!=null && dogDnaArchive.getId()!=null){
	// dogDnaArchive.setType("1");
	// list.add(dogDnaArchive);
	// }
	// }
	// //只查询血样留存
	// if(StringUtils.isNotBlank(ttttype) && ttttype.equals("2")){
	// //if(dogDnaArchive==null || dogDnaArchive.getId()==null){//血样留存
	// test(list,dogDnaArchive,dogBloodSave2);
	// //}
	// }
	// }
	// return list;
	// }

	public Page<DogDnaArchive> findPageAll(Page<DogDnaArchive> page, List<DogDnaArchive> list,
			DogDnaArchive dogDnaArchive, Page<DogBloodSave> dogBloodSavePage) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		page.setCount(dogBloodSavePage.getCount());
		dogDnaArchive.setPage(page);
		page.setList(list);
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<DogDnaArchive>(0));
		}
		return page;
	}

	@Transactional(readOnly = false)
	public void afterPay(String ids) {
		String[] idArr = ids.split(",");
		Stream.of(idArr).forEach(id -> {
			DogBloodSave dogBloodSave = dao.get(id);
			if ("2".equals(dogBloodSave.getTypeYes())) {
				dogBloodSave.setFinishTime(new Date());
				dogBloodSave.preUpdate();
				dao.update(dogBloodSave);
			}
		});
	}

	@Transactional(readOnly = false)
	public void updateOrg(String birthCode, String orgId) {
		dao.updateOrg(birthCode, orgId);
	}

	// 转换
	// public void test(List<DogDnaArchive> list,DogDnaArchive
	// dogDnaArchive,DogBloodSave dogBloodSave2){
	// dogDnaArchive = new DogDnaArchive();
	// //获取缺失数据
	// dogDnaArchive.setType("2");
	// dogDnaArchive.setId(dogBloodSave2.getId());
	// dogDnaArchive.setBirthCode(dogBloodSave2.getBirthCode());
	// dogDnaArchive.setPedigreeCertifiedCode(dogBloodSave2.getPedigreeCertified());
	// //根据芯片号查询犬只信息
	//// Dog dog = null;
	//// Dog byBirthCertificateLevelCode =
	// dogDao.getByBirthCertificateLevelCodeTwo(dogBloodSave2.getBirthCode());
	//// dogDnaArchive.setChipCode(byBirthCertificateLevelCode.getIdentificationFlag());
	//// dogDnaArchive.setDogBreed(byBirthCertificateLevelCode.getDogBreed());
	//// dogDnaArchive.setDogName(byBirthCertificateLevelCode.getNameEn());
	//
	// dogDnaArchive.setChipCode(dogBloodSave2.getChipCode());
	// dogDnaArchive.setDogBreed(dogBloodSave2.getDogBreed());
	// dogDnaArchive.setDogName(dogBloodSave2.getDogName());
	// dogDnaArchive.setPaymentMemberCode(dogBloodSave2.getPaymentMemberCode());
	// //查询会员
	// //Member member =
	// memberService.getByMemberCode(dogBloodSave2.getPaymentMemberCode());
	// dogDnaArchive.setMemberName(dogBloodSave2.getName());
	// dogDnaArchive.setPaymentState(dogBloodSave2.getPaymentState());
	// dogDnaArchive.setTypeYes(dogBloodSave2.getTypeYes());
	// list.add(dogDnaArchive);
	// }

	@Transactional(readOnly = false)
	public DogBloodSave getByRunningMumber(String runningNumber) {
		return dao.getByRunningMumber(runningNumber);
	}

	@Transactional(readOnly = false)
	public void addDogBloodSaveOEC(DogBloodSave add) throws ZAException {
		if (StringUtils.isBlank(add.getBirthCode()) && StringUtils.isBlank(add.getPedigreeCertified())
				&& StringUtils.isBlank(add.getOverseasPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只标识未传");
		}
		DogBloodSave dogBloodSave = new DogBloodSave();
		if (StringUtils.isNotBlank(add.getPedigreeCertified())) {
			Dog dog = dogService.getByPedigreeCertifiedCode(add.getPedigreeCertified());
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
			}
			// 0根据出生纸编号查重
			if (dao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode()) != null) {
				return;// 有证书则不插入记录
			}
			DogAppraisal dogAppraisal = dogAppraisalDao.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
			if (dogAppraisal != null) {
				dogBloodSave.setShowAppraisalCode(dogAppraisal.getShowAppraisalCode());
			}
			dogBloodSave.setBirthCode(dog.getBirthCertificateLevelCode());
			dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
			dogBloodSave.setOverseasPedigreeCertified(dog.getPedigreeCertifiedEn());
		} else if (StringUtils.isNotBlank(add.getBirthCode())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
					.getByBirthCerRegCode(add.getBirthCode());
			if (dogBirthCertificate == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生纸编号有误");
			}
			// 0根据出生纸编号查重
			if (dao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode()) != null) {
				return;// 有证书则不插入记录
			}
			dogBloodSave.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
			dogBloodSave.setPedigreeCertified(dogBirthCertificate.getPedigreeCertified());
		} else if (StringUtils.isNotBlank(add.getOverseasPedigreeCertified())) {// 根据外国血统证书号（证书换发）的订单录入
			DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeDao
					.getByPedigreeCertified(add.getOverseasPedigreeCertified());
			if (dogPedigreeCertifiedChange == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "外国血统证书号有误");
			}
			dogBloodSave.setOverseasPedigreeCertified(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
		}
		dogBloodSave.setPaymentMemberCode(add.getPaymentMemberCode());
		dogBloodSave.setPrice("0.00");
		if (StringUtils.isBlank(add.getRunningNumber())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号未传");
		}
		dogBloodSave.setRunningNumber(add.getRunningNumber());
		if (StringUtils.isBlank(add.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号未传");
		}
		dogBloodSave.setPaymentMemberCode(add.getPaymentMemberCode());
		dogBloodSave.setPaymentState("2");
		dogBloodSave.setPaymentTime(paymentOrderService.getPaymentTimeByOrderCode(add.getRunningNumber()));
		dogBloodSave.setIsCanceled("0");
		dogBloodSave.setOrgId(add.getOrgId());
		dogBloodSave.setIsOEC("1");
		super.save(dogBloodSave);
	}

	@Transactional(readOnly = false)
	public DogBloodSave getOneByParam(String birthCode, String overseasPedigreeCertified, String showAppraisalCode,
			String pedigreeCertified) {

		return dao.getOneByParam(birthCode, overseasPedigreeCertified, showAppraisalCode, pedigreeCertified);
	}

	@Transactional(readOnly = false)
	public void cancel(DogBloodSave dogBloodSave) {

		if (!"2".equals(dogBloodSave.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已缴费才可撤销");
		}
		if (Global.YES.equals(dogBloodSave.getIsCanceled())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该DNA血样留存已是撤销状态");
		}
		// 状态置为撤销
		dogBloodSave.setIsCanceled(Global.YES);
		dogBloodSave.preUpdate();
		dao.update(dogBloodSave);
	}

	/**
	 * 修改DNA存档采集状态
	 *
	 * @author yuanshuai
	 * @since 2024/1/11 15:09
	 */
	@Transactional(readOnly = false)
	public void updateIsOEC(DogBloodSave dogBloodSave) {
		dogBloodSave.preUpdate();
		dao.updateIsOec(dogBloodSave);

	}
}