/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity.dogamphimixis;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 换发配种证明Entity
 * @author cxt
 * @version 2016-09-10
 */
public class DogAmphimixisProve extends DataEntity<DogAmphimixisProve> {
	
	private static final long serialVersionUID = 1L;
	private String fmdogBreedCertifiedCode;		// 父母犬配犬证明号
	private String dogBreed;		// 种类
	private Date amphimixisDate;		// 配犬日期
	private String fdogPedigreeCertified;		// 父犬血统证书号
	private String mdogPedigreeCertified;		// 母犬血统证书号
	private String kennelName;		// 犬舍名称
	private String numberBirths;		// 本胎数量
	private String numberStillbirths;		// 死胎数量
	private String numberAbort;		// 夭折数量
	private String numberDeathsPuppies;		// 死亡幼犬数
	private String numberFosterDogs;		// 寄养犬数
	private String numberHerdsDogs;		// 存栏犬数
	private String numberRegisteredDogs;		// 登记犬数
	private String sameFetalDog;		// 同胎犬
	private String breeder;		// 繁殖人
	private String breederAddress;		// 繁殖人地址
	private String breederMemberCode;		// 繁育人会员号
	
	private String changeId; //临时存储字段
	
	
	public String getChangeId() {
		return changeId;
	}

	public void setChangeId(String changeId) {
		this.changeId = changeId;
	}

	public DogAmphimixisProve() {
		super();
	}

	public DogAmphimixisProve(String id){
		super(id);
	}

	@Length(min=0, max=100, message="父母犬配犬证明号长度必须介于 0 和 100 之间")
	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}
	
	@Length(min=0, max=64, message="种类长度必须介于 0 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAmphimixisDate() {
		return amphimixisDate;
	}

	public void setAmphimixisDate(Date amphimixisDate) {
		this.amphimixisDate = amphimixisDate;
	}
	
	@Length(min=0, max=100, message="父犬血统证书号长度必须介于 0 和 100 之间")
	public String getFdogPedigreeCertified() {
		return fdogPedigreeCertified;
	}

	public void setFdogPedigreeCertified(String fdogPedigreeCertified) {
		this.fdogPedigreeCertified = fdogPedigreeCertified;
	}
	
	@Length(min=0, max=100, message="母犬血统证书号长度必须介于 0 和 100 之间")
	public String getMdogPedigreeCertified() {
		return mdogPedigreeCertified;
	}

	public void setMdogPedigreeCertified(String mdogPedigreeCertified) {
		this.mdogPedigreeCertified = mdogPedigreeCertified;
	}
	
	@Length(min=0, max=100, message="犬舍名称长度必须介于 0 和 100 之间")
	public String getKennelName() {
		return kennelName;
	}

	public void setKennelName(String kennelName) {
		this.kennelName = kennelName;
	}
	
	@Length(min=0, max=60, message="本胎数量长度必须介于 0 和 60 之间")
	public String getNumberBirths() {
		return numberBirths;
	}

	public void setNumberBirths(String numberBirths) {
		this.numberBirths = numberBirths;
	}
	
	@Length(min=0, max=64, message="死胎数量长度必须介于 0 和 64 之间")
	public String getNumberStillbirths() {
		return numberStillbirths;
	}

	public void setNumberStillbirths(String numberStillbirths) {
		this.numberStillbirths = numberStillbirths;
	}
	
	@Length(min=0, max=64, message="夭折数量长度必须介于 0 和 64 之间")
	public String getNumberAbort() {
		return numberAbort;
	}

	public void setNumberAbort(String numberAbort) {
		this.numberAbort = numberAbort;
	}
	
	@Length(min=0, max=64, message="死亡幼犬数长度必须介于 0 和 64 之间")
	public String getNumberDeathsPuppies() {
		return numberDeathsPuppies;
	}

	public void setNumberDeathsPuppies(String numberDeathsPuppies) {
		this.numberDeathsPuppies = numberDeathsPuppies;
	}
	
	@Length(min=0, max=64, message="寄养犬数长度必须介于 0 和 64 之间")
	public String getNumberFosterDogs() {
		return numberFosterDogs;
	}

	public void setNumberFosterDogs(String numberFosterDogs) {
		this.numberFosterDogs = numberFosterDogs;
	}
	
	@Length(min=0, max=64, message="存栏犬数长度必须介于 0 和 64 之间")
	public String getNumberHerdsDogs() {
		return numberHerdsDogs;
	}

	public void setNumberHerdsDogs(String numberHerdsDogs) {
		this.numberHerdsDogs = numberHerdsDogs;
	}
	
	@Length(min=0, max=64, message="登记犬数长度必须介于 0 和 64 之间")
	public String getNumberRegisteredDogs() {
		return numberRegisteredDogs;
	}

	public void setNumberRegisteredDogs(String numberRegisteredDogs) {
		this.numberRegisteredDogs = numberRegisteredDogs;
	}
	
	@Length(min=0, max=255, message="同胎犬长度必须介于 0 和 255 之间")
	public String getSameFetalDog() {
		return sameFetalDog;
	}

	public void setSameFetalDog(String sameFetalDog) {
		this.sameFetalDog = sameFetalDog;
	}
	
	@Length(min=0, max=64, message="繁殖人长度必须介于 0 和 64 之间")
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}
	
	@Length(min=0, max=200, message="繁殖人地址长度必须介于 0 和 200 之间")
	public String getBreederAddress() {
		return breederAddress;
	}

	public void setBreederAddress(String breederAddress) {
		this.breederAddress = breederAddress;
	}
	
	@Length(min=0, max=64, message="繁育人会员号长度必须介于 0 和 64 之间")
	public String getBreederMemberCode() {
		return breederMemberCode;
	}

	public void setBreederMemberCode(String breederMemberCode) {
		this.breederMemberCode = breederMemberCode;
	}
	
}