/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 第二繁殖人Entity
 * @author wj
 * @version 2020-08-13
 */
public class DogSecondBreeder extends DataEntity<DogSecondBreeder> {

	private static final long serialVersionUID = 1L;
	private String breedCertifiedCode;		// 配种证明编号
	private String breederMemberCode;		// 繁殖人会员号
	private String breeder;		// 繁殖人姓名
	private String secondBreederMemberCode;		// 第二繁殖人会员号
	private String secondBreeder;		// 第二繁殖人姓名
	private String paymentState;		// 付款状态
	private Date paymentTime;		// 付款时间
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核备注
	private String runningNumber;		// 流水号
	private String processState;		// 流程状态
	private Date processTime;		// 流程变更时间

	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date


	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public DogSecondBreeder() {
		super();
	}

	public DogSecondBreeder(String id){
		super(id);
	}

	@Length(min=1, max=64, message="配种证明编号长度必须介于 1 和 64 之间")
	public String getBreedCertifiedCode() {
		return breedCertifiedCode;
	}

	public void setBreedCertifiedCode(String breedCertifiedCode) {
		this.breedCertifiedCode = breedCertifiedCode;
	}

	@Length(min=1, max=64, message="繁殖人会员号长度必须介于 1 和 64 之间")
	public String getBreederMemberCode() {
		return breederMemberCode;
	}

	public void setBreederMemberCode(String breederMemberCode) {
		this.breederMemberCode = breederMemberCode;
	}

	@Length(min=1, max=64, message="繁殖人姓名长度必须介于 1 和 64 之间")
	public String getBreeder() {
		return breeder;
	}

	public void setBreeder(String breeder) {
		this.breeder = breeder;
	}

	@Length(min=1, max=64, message="第二繁殖人会员号长度必须介于 1 和 64 之间")
	public String getSecondBreederMemberCode() {
		return secondBreederMemberCode;
	}

	public void setSecondBreederMemberCode(String secondBreederMemberCode) {
		this.secondBreederMemberCode = secondBreederMemberCode;
	}

	@Length(min=1, max=64, message="第二繁殖人姓名长度必须介于 1 和 64 之间")
	public String getSecondBreeder() {
		return secondBreeder;
	}

	public void setSecondBreeder(String secondBreeder) {
		this.secondBreeder = secondBreeder;
	}

	@Length(min=1, max=1, message="付款状态长度必须介于 1 和 1 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min=1, max=1, message="审核状态长度必须介于 1 和 1 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min=0, max=200, message="审核备注长度必须介于 0 和 200 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min=0, max=64, message="流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min=1, max=1, message="流程状态长度必须介于 1 和 1 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

}