/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * DNA血样留存Entity
 *
 * @author lgl
 * @version 2016-11-24
 */
public class DogBloodSave extends DataEntity<DogBloodSave> {

	private static final long serialVersionUID = 1L;
	private String birthCode; // 出生纸编号
	private String overseasPedigreeCertified; // 国外血统证书号
	private String showAppraisalCode; // 赛场鉴定编号
	private String bloodSampleCode; // DNA血样编号
	private String paymentMemberCode; // 付款会员号
	private String price; // 订单价格
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private Date finishTime; // 完成时间
	private Date create_date; // 申请时间
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private String name;// 付款会员姓名
	private String pedigreeCertified;// 血统证书号
	private String dogName;// 犬名
	private Date dogBirthday; // 犬生日
	private String dogGender; // 犬性别
	private String isCanceled; // 是否撤销:否0；是1
	private String dogBreed; // 犬种
	private String chipCode;// 芯片号
	private String paymentChargingItemId; // 收费项id
	private String organizationName; // 办理机构
	private String typeYes;// 是否完成
	private String delete;// 是否允许删除 标记位置
	private String orgId;
	private String province;//省份
	private String type;//省份
	
	private Date beginFinishDate;
	private Date endFinishDate;
	
	private String isOEC; // 是否为口腔上皮细胞测试法:否0；是1
	
	
	public String getIsOEC() {
		return isOEC;
	}

	public void setIsOEC(String isOEC) {
		this.isOEC = isOEC;
	}
	public Date getBeginFinishDate() {
		return beginFinishDate;
	}

	public void setBeginFinishDate(Date beginFinishDate) {
		this.beginFinishDate = beginFinishDate;
	}

	public Date getEndFinishDate() {
		return endFinishDate;
	}

	public void setEndFinishDate(Date endFinishDate) {
		this.endFinishDate = endFinishDate;
	}

	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	public String getOrganizationName() {
		return organizationName;
	}

	public void setOrganizationName(String organizationName) {
		this.organizationName = organizationName;
	}

	public String getFmdogBreedCertifiedCode() {
		return fmdogBreedCertifiedCode;
	}

	public void setFmdogBreedCertifiedCode(String fmdogBreedCertifiedCode) {
		this.fmdogBreedCertifiedCode = fmdogBreedCertifiedCode;
	}

	private String fmdogBreedCertifiedCode;// 配种证明号

	public DogBloodSave() {
		super();
	}

	public DogBloodSave(String id) {
		super(id);
	}

	public DogBloodSave(String runningNumber, String paymentChargingItemId, String paymentMemberCode) {
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 1, max = 64, message = "出生纸编号长度必须介于 1 和 64 之间")
	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}

	public String getOverseasPedigreeCertified() {
		return overseasPedigreeCertified;
	}

	public void setOverseasPedigreeCertified(String overseasPedigreeCertified) {
		this.overseasPedigreeCertified = overseasPedigreeCertified;
	}

	public String getShowAppraisalCode() {
		return showAppraisalCode;
	}

	public void setShowAppraisalCode(String showAppraisalCode) {
		this.showAppraisalCode = showAppraisalCode;
	}

	@Length(min = 1, max = 64, message = "DNA血样编号长度必须介于 1 和 64 之间")
	public String getBloodSampleCode() {
		return bloodSampleCode;
	}

	public void setBloodSampleCode(String bloodSampleCode) {
		this.bloodSampleCode = bloodSampleCode;
	}

	@Length(min = 1, max = 64, message = "付款会员号长度必须介于 1 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 1, max = 20, message = "付款的状态长度必须介于 1 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public Date getCreate_date() {
		return create_date;
	}

	public void setCreate_date(Date create_date) {
		this.create_date = create_date;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getIsCanceled() {
		return isCanceled;
	}

	public void setIsCanceled(String isCanceled) {
		this.isCanceled = isCanceled;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}

	public String getTypeYes() {
		return typeYes;
	}

	public void setTypeYes(String typeYes) {
		this.typeYes = typeYes;
	}

	public String getDelete() {
		return delete;
	}

	public void setDelete(String delete) {
		this.delete = delete;
	}
}