/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只鼻纹Entity
 * 
 * @author xx
 * @version 2020-05-14
 */
public class DogBirthCertificateTransfer extends DataEntity<DogBirthCertificateTransfer> {

	private static final long serialVersionUID = 1L;
	private String transferorMemberCode; // 转出犬主会员号
	private String transferorMemberName; // 转出犬主
	private String receiverMemberCode; // 新犬主会员号
	private String receiverMemberName; // 新犬主
	private String dogBirthCertificateId; // 登记卡id

	private String birthCode; // 登记卡号

	private Date beginCreateDate; // 查询条件
	private Date endCreateDate; // 查询条件
	private String memberKey; // 查询条件

	private String dogGender; // 性别
	private String dogEnName; // 英文犬名
	private String dogBreed; // 犬种
	private Date dogBirth; // 出生日期
	private String idNo; // 芯片号
	private String cabPassport; // 宠爱护照号

	private String memberBreedName; // 繁殖人
	private String memberBreedCode;

	private String memberName; // 新犬主
	private String memberCode;
	private String businessStatus; // 业务状态
	private String remark; // 备注
	private String businessFlag;
	
	private String reviewBy;
	private Date reviewDate;
	
	public DogBirthCertificateTransfer() {
		super();
	}

	public DogBirthCertificateTransfer(String id) {
		super(id);
	}

	public void setTransferorMemberCode(String transferorMemberCode) {
		this.transferorMemberCode = transferorMemberCode;
	}

	@Length(min = 0, max = 50, message = "转出犬主长度必须介于 0 和 50 之间")
	public String getTransferorMemberName() {
		return transferorMemberName;
	}

	public void setTransferorMemberName(String transferorMemberName) {
		this.transferorMemberName = transferorMemberName;
	}

	@Length(min = 1, max = 50, message = "新犬主会员号长度必须介于 1 和 50 之间")
	public String getReceiverMemberCode() {
		return receiverMemberCode;
	}

	public void setReceiverMemberCode(String receiverMemberCode) {
		this.receiverMemberCode = receiverMemberCode;
	}

	@Length(min = 0, max = 50, message = "新犬主长度必须介于 0 和 50 之间")
	public String getReceiverMemberName() {
		return receiverMemberName;
	}

	public void setReceiverMemberName(String receiverMemberName) {
		this.receiverMemberName = receiverMemberName;
	}

	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getMemberKey() {
		return memberKey;
	}

	public void setMemberKey(String memberKey) {
		this.memberKey = memberKey;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getDogEnName() {
		return dogEnName;
	}

	public void setDogEnName(String dogEnName) {
		this.dogEnName = dogEnName;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public Date getDogBirth() {
		return dogBirth;
	}

	public void setDogBirth(Date dogBirth) {
		this.dogBirth = dogBirth;
	}

	public String getIdNo() {
		return idNo;
	}

	public void setIdNo(String idNo) {
		this.idNo = idNo;
	}

	public String getMemberBreedName() {
		return memberBreedName;
	}

	public void setMemberBreedName(String memberBreedName) {
		this.memberBreedName = memberBreedName;
	}

	public String getMemberBreedCode() {
		return memberBreedCode;
	}

	public void setMemberBreedCode(String memberBreedCode) {
		this.memberBreedCode = memberBreedCode;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getBusinessStatus() {
		return businessStatus;
	}

	public void setBusinessStatus(String businessStatus) {
		this.businessStatus = businessStatus;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getCabPassport() {
		return cabPassport;
	}

	public void setCabPassport(String cabPassport) {
		this.cabPassport = cabPassport;
	}

	public String getDogBirthCertificateId() {
		return dogBirthCertificateId;
	}

	public void setDogBirthCertificateId(String dogBirthCertificateId) {
		this.dogBirthCertificateId = dogBirthCertificateId;
	}

	public String getTransferorMemberCode() {
		return transferorMemberCode;
	}

	public String getBusinessFlag() {
		return businessFlag;
	}

	public void setBusinessFlag(String businessFlag) {
		this.businessFlag = businessFlag;
	}

	public String getReviewBy() {
		return reviewBy;
	}

	public void setReviewBy(String reviewBy) {
		this.reviewBy = reviewBy;
	}

	public Date getReviewDate() {
		return reviewDate;
	}

	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}
	
	

}