package com.cku.oa.components.rule.validation.kennel;

import com.cku.oa.kennel.entity.Kennel;
import org.springframework.stereotype.Component;

/**
 * Created by laiguanglong on 2017/4/24.
 */
@Component
public class KennelCondition {
    /**
     * @description: FCI国际犬舍是否有效
     * @author: laiguanglong
     * @date: 2017/4/24 10:11
     */
    public boolean isActiveFCIKennel(Kennel kennel) {
        boolean flag = false;
        if (kennel != null
                && kennel.getEndTime() != null
                && kennel.getEndTime().getTime() + 86399000 > System.currentTimeMillis()
                && "1".equals(kennel.getReviewState())
                && "1".equals(kennel.getFciReviewState())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 犬舍是否有效
     * @author: laiguanglong
     * @date: 2017/4/26 18:11
     */
    public boolean isActiveKennel(Kennel kennel) {
        boolean flag = false;
        if (kennel != null
                && kennel.getEndTime() != null
                && kennel.getEndTime().getTime() + 86399000 > System.currentTimeMillis()
                && "1".equals(kennel.getReviewState())) {
            flag = true;
        }
        return flag;
    }
}