package com.cku.oa.components.rule.validation.championlogin;

import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.dao.DogDnaDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChampionLoginCondition {

    @Autowired
    public DogDnaArchiveDao dogDnaArchiveDao;
    @Autowired
    public DogDnaDao dogDnaDao;
    @Autowired
    public ChampionLoginDao championLoginDao;


    /**
     * @Description：是否完成登录
     * @author: zhuoHeng
     * @version: 2016年8月29日 上午10:44:29
     */
    public boolean isHaveChampionLogin(Dog dog, Integer loginType) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())
                && loginType != null
                && StringUtils.isNotBlank(loginType.toString())) {
            Long count = championLoginDao.getChampionLoginCount(loginType.toString(), dog.getPedigreeCertifiedCode(),"1");
            if (count > 0) {
                flag = true;
            }
        }
        return flag;
    }

    /**
     * @description: 犬只获得BOB/ BOS/BOW成绩
     * @author: laiguanglong
     * @date: 2017/4/24 17:53
     */
    public boolean isBOB_BOS_BOWCountCreaterThan(Dog dog, Integer count) {
        boolean flag = false;
        if (dog != null
                && StringUtils.isNotBlank(dog.getPedigreeCertifiedCode())
                && count >= championLoginDao.countBOB_BOS_BOW(dog.getPedigreeCertifiedCode())) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 冠军登录记录是否存在
     * @author: laiguanglong
     * @date: 2017/4/24 15:25
     */
    public boolean isChampionLoginNotExit(ChampionLogin po) {
        boolean flag = true;
        ChampionLogin example = new ChampionLogin();
        example.setPedigreeCertified(po.getPedigreeCertified());
        example.setLoginType(po.getLoginType());
        if (championLoginDao.findList(example).size() > 0) {
            flag = false;
        }
        return flag;
    }

    /**
     * @description: 铜制冠军登录赛事成绩校验
     * 3、《铜质冠军资质证书》
     * 获得8张CC（至少4张CC，其余RCC），并且须获得1次BOB/ BOS/BOW其中一项成绩。
     * @author: laiguanglong
     * @date: 2017/4/26 14:04
     */
    public boolean validateTongLogin(Dog dog) {
        if (dog == null || StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
            return false;
        }
        String pedigreeCertified = dog.getPedigreeCertifiedCode();
        int countCC = championLoginDao.countCC(pedigreeCertified);
        if (countCC < 4) {
            return false;
        } else if (countCC < 8) {
            //至少4张CC，其余RCC
            int countRCC = championLoginDao.countRCC(pedigreeCertified);
            if ((countCC + countRCC / 2) < 8) {
                return false;
            }
        }
        int countBOB_BOS_BOW = championLoginDao.countBOB_BOS_BOW(pedigreeCertified);
        if (countBOB_BOS_BOW < 1) {
            return false;
        }
        return true;
    }

    /**
     * @description: 银制冠军登录赛事成绩校验
     * 4、《银质冠军资质证书》
     * 获得12张CC（至少8张CC，其余RCC），并且须获得2次BOB成绩（不同裁判授予）。
     * @author: laiguanglong
     * @date: 2017/4/26 14:04
     */
    public boolean validateYinLogin(Dog dog) {
        if (dog == null || StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
            return false;
        }
        String pedigreeCertified = dog.getPedigreeCertifiedCode();
        int countCC = championLoginDao.countCC(pedigreeCertified);
        if (countCC < 8) {
            return false;
        } else if (countCC < 12) {
            int countRCC = championLoginDao.countRCC(pedigreeCertified);
            if ((countCC + countRCC / 2) < 12) {
                return false;
            }
        }
        int countBOB = championLoginDao.countBOB(pedigreeCertified);
        if (countBOB < 2) {
            return false;
        }
        return true;
    }

    /**
     * @description: 金制冠军登录赛事成绩校验
     * 5、《金质冠军资质证书》
     * 获得20张CC（至少12张CC，其余RCC），并且须获得2次BIG成绩（不同裁判授予）。
     * @author: laiguanglong
     * @date: 2017/4/26 14:04
     */
    public boolean validateJinLogin(Dog dog) {
        if (dog == null || StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
            return false;
        }
        String pedigreeCertified = dog.getPedigreeCertifiedCode();
        int countCC = championLoginDao.countCC(pedigreeCertified);
        if (countCC < 12) {
            return false;
        } else if (countCC < 20) {
            int countRCC = championLoginDao.countRCC(pedigreeCertified);
            if ((countCC + countRCC / 2) < 20) {
                return false;
            }
        }
        int countBIG = championLoginDao.countBIG(pedigreeCertified);
        if (countBIG < 2) {
            return false;
        }
        return true;
    }

    /**
     * @description: 超级冠军登录赛事成绩校验
     * 6、《超级冠军资质证书》
     * 获得20张CC（至少15张CC，其余RCC），并且须获得2次BIS成绩（不同裁判授予）。
     * @author: laiguanglong
     * @date: 2017/4/26 14:04
     */
    public boolean validateSuperLogin(Dog dog) {
        if (dog == null || StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
            return false;
        }
        String pedigreeCertified = dog.getPedigreeCertifiedCode();
        int countCC = championLoginDao.countCC(pedigreeCertified);
        if (countCC < 15) {
            return false;
        } else if (countCC < 20) {
            int countRCC = championLoginDao.countRCC(pedigreeCertified);
            if ((countCC + countRCC / 2) < 20) {
                return false;
            }
        }
        int countBIS = championLoginDao.countBIS(pedigreeCertified);
        if (countBIS < 2) {
            return false;
        }
        return true;
    }

    /**
     * @description: 世界冠军登录赛事成绩校验
     * 获得4张以上CACIB卡
     * @author: laiguanglong
     * @date: 2017/4/26 15:06
     */
    public boolean validateWorldLogin(Dog dog){
        if (dog == null || StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
            return false;
        }
        String pedigreeCertified = dog.getPedigreeCertifiedCode();
        int countCACIB = championLoginDao.countCACIB(pedigreeCertified);
        if(countCACIB<4){
            return false;
        }
        return true;
    }
}