package com.cku.oa.banner.dao;

import java.util.List;

import com.cku.oa.banner.entity.AppBanner;
import com.cku.restful.v1.banner.vo.RestBannerListRequest;
import com.cku.restful.v1.banner.vo.RestBannerListResponse;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

@MyBatisDao
public interface AppBannerDao extends CrudDao<AppBanner> {

	/**
	 * 编辑状态
	 */
	int editStatus(AppBanner appBanner);

	/**
	 * 根据条件查询总条数
	 */
	Integer listCount(RestBannerListRequest vo);

	/**
	 * 根据条件查询列表
	 */
	List<RestBannerListResponse> list(RestBannerListRequest vo);
	
	/**
	 * 根据条件查询banner
	 */
	AppBanner findByParam(AppBanner appBanner);
}
