//犬舍名称变更列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //犬舍变更列表
        me.listData = ko.observableArray([]);
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //会员信息
        me.member = ko.observable({});
        //犬舍信息
        me.kennel = ko.observable({});
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findkennelrenamelist(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findkennelrenamelist(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findkennelrenamelist(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findkennelrenamelist(false);
            }
            return false;
        }
        me.addKennelNameCnShow = ko.observable("");
        me.addKennelNameEnShow = ko.observable("");
        me.addKennelNameCheckFlag = ko.observable(false);
        me.addKennelNameEnCheckFlag = ko.observable(false);
        me.updateKennelNameCnShow = ko.observable("");
        me.updateKennelNameEnShow = ko.observable("");
        me.updateKennelNameCheckFlag = ko.observable(false);
        me.updateKennelNameEnCheckFlag = ko.observable(false);
        //添加校验中文名称
        me.checkAddKennelNameCn = function(){
            var sendData = {isCheckType:"name",name:me.addKennelrename().newNameCn};
            util.sendAjax({
                url:'kennel/checkKennelName',
                data:JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    console.log(json);
                    if(json.rc==0){
                        me.addKennelNameCnShow("犬舍中文名正确");
                        me.addKennelNameCheckFlag(true);
                    }else{
                        me.addKennelNameCnShow(json.msg);
                        me.addKennelNameCheckFlag(false);
                    }
                }
            });
        }
        //添加校验英文名称
        me.checkAddKennelNameEn = function(){
            var sendData = {isCheckType:"nameEn",nameEn:me.addKennelrename().newNameEn};
            util.sendAjax({
                url:'kennel/checkKennelName',
                data:JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    console.log(json);
                    if(json.rc==0){
                        me.addKennelNameEnShow("犬舍英文名正确");
                        me.addKennelNameEnCheckFlag(true);
                    }else{
                        me.addKennelNameEnShow(json.msg);
                        me.addKennelNameEnCheckFlag(false);
                    }

                }
            });
        }
        //修改校验中文名称
        me.checkUpdateKennelNameCn = function(){
            var sendData = {isCheckType:"name",name:me.updateKennelrename().newNameCn};
            util.sendAjax({
                url:'kennel/checkKennelName',
                data:JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    console.log(json);
                    if(json.rc==0){
                        me.updateKennelNameCnShow("犬舍中文名正确");
                        me.updateKennelNameCheckFlag(true);
                    }else{
                        me.updateKennelNameCnShow(json.msg);
                        me.updateKennelNameCheckFlag(false);
                    }
                }
            });
        }
        //修改校验英文名称
        me.checkUpdateKennelNameEn = function(){
            var sendData = {isCheckType:"nameEn",nameEn:me.updateKennelrename().newNameEn};
            util.sendAjax({
                url:'kennel/checkKennelName',
                data:JSON.stringify(sendData),
                async:false,
                type:'POST',
                cache:false,
                success:function(json){
                    console.log(json);
                    if(json.rc==0){
                        me.updateKennelNameEnShow("犬舍英文名正确");
                        me.updateKennelNameEnCheckFlag(true);
                    }else{
                        me.updateKennelNameEnShow(json.msg);
                        me.updateKennelNameEnCheckFlag(false);
                    }

                }
            });
        }

        //添加犬舍名称变更参数
        me.addKennelrename = ko.observable({newNameCn:"",newNameEn:""});
        //修改犬舍名称变更参数
        me.updateKennelrename = ko.observable({id:'',newNameCn:"",newNameEn:""});
        //展现添加犬舍变更div
        me.showAddKennelrenameFun = function(){
            util.sendAjax({
                url:'kennel/kennelrename/getPrice',
                data:JSON.stringify(),
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        $("#price").html(json.data.price+"元");
                    }else{
                        layer.msg("获取价格错误:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
            if($("#addKennelrenameDiv").css("display")=="none"){
                $("#addKennelrenameDiv").css("display","block");
            }else{
                $("#addKennelrenameDiv").css("display","none");
            }
        }
        //添加犬舍变更接口
        me.addKennelrenameFun = function(){
            if(!(me.addKennelNameCheckFlag() && me.addKennelNameEnCheckFlag())){
                layer.msg("犬舍名称不符合规则，请重新确认。");
                return;
            }
            var newNameCn =  me.addKennelrename().newNameCn;
            newNameCn = util.removeg(newNameCn);
            var newNameEn = me.addKennelrename().newNameEn;
            newNameEn = newNameEn.trim();
            //if(util.isVal(newNameCn)=="" || newNameCn.length>4 ||util.isZhWord(newNameCn)){
            //    layer.msg("犬舍中文名仅限输入汉字，长度在4个汉字以内！");
            //    return;
            //}
            //if(util.isVal(newNameEn)=="" || newNameEn.length>30 ||!util.isEnWord(newNameEn)){
            //    layer.msg("犬舍英文名仅限输入英文字母，长度在30个字符以内！");
            //    return;
            //}
            var sendData = {newNameCn:newNameCn,newNameEn:newNameEn};
            util.sendAjax({
                url:'kennel/kennelrename',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                    	context.app.changeCart();
                        layer.alert('业务添加成功，是否跳转到业务核对页面进行支付？', {
                            time: 0 //不自动关闭
                            ,btn: ['跳转', '取消']
                            ,yes: function(index){
                                layer.close(index);
                                location.href = location.href.split("#")[0]+"#/order/check";
                            }
                        });
                    }else{
                        layer.msg("犬舍变更失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //展现修改犬舍变更div
        me.showUpdateKennelrenameFun = function(data,event){
            if($("#updateKennelrenameDiv").css("display")=="none"){
                $("#updateKennelrenameDiv").css("display","block");
                me.updateKennelrename().id = data.id;
                me.updateKennelrename().newNameCn = data.newNameCn.substr(0,(data.newNameCn.length-2));
                me.updateKennelrename().newNameEn = data.newNameEn;
                $("#updateNewNameCn").val(me.updateKennelrename().newNameCn);
                $("#updateNewNameEn").val(data.newNameEn);
            }else{
                $("#updateKennelrenameDiv").css("display","none");
            }
        }
        //修改犬舍变更接口
        me.updateKennelrenameFun = function(){
            if(!(me.updateKennelNameCheckFlag() && me.updateKennelNameEnCheckFlag())){
                layer.msg("犬舍名称不符合规则，请重新确认。");
                return;
            }
            var id = me.updateKennelrename().id;
            var newNameCn =  me.updateKennelrename().newNameCn;
            newNameCn = util.removeg(newNameCn);
            var newNameEn = me.updateKennelrename().newNameEn;
            newNameEn = newNameEn.trim();
            //if(util.isVal(newNameCn)=="" || newNameCn.length>4 ||util.isZhWord(newNameCn)){
            //    layer.msg("犬舍中文名仅限输入汉字，长度在4个汉字以内！");
            //    return;
            //}
            //if(util.isVal(newNameEn)=="" || newNameEn.length>30 ||!util.isEnWord(newNameEn)){
            //    layer.msg("犬舍英文名仅限输入英文字母，长度在30个字符以内！");
            //    return;
            //}
            var sendData = {id:id,newNameCn:newNameCn,newNameEn:newNameEn};
            util.sendAjax({
                url:'kennel/kennelrename',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'PUT',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        layer.msg("修改成功！");
                        me.findkennelrenamelist(false);
                        $("#updateKennelrenameDiv").css("display","none");
                    }else{
                        layer.msg("修改犬舍变更失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        //犬舍变更列表
        me.findkennelrenamelist = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'kennel/kennelrename',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            me.listData(json.list);

                        }else{
                            me.listData([]);
                            layer.msg("犬舍变更列表为空！");
                        }
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询犬舍变更列表失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }

        $(function(){
            me.findkennelrenamelist(false);
            me.kennel(context.app.kennel());
            me.member(userInfo.getMember());
        })

        context.app.loading(false);
        context.app.isShop(false);
    }
});