//新生犬登记申请列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        me.member = ko.observable({});
        //列表数据
        me.listData = ko.observableArray([]);
        //申请批次号
        me.semenBatchCode = ko.observable("");
        //血统证书号
        me.pedigreeCertified = ko.observable("");
        //CKU精子编号
        me.semenCode = ko.observable("");

        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //详细数据
        me.detailData = ko.observable({
            pedigreeCertified:"",
            dogChip:"",
            dogBreed:"",
            dogName:"",
            dogOwner:"",
            originalSemenCode:"",
            semenCode:"",
            breedCertifiedCode:""
        });
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findnewdogchipList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findnewdogchipList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findnewdogchipList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findnewdogchipList(false);
            }
            return false;
        }
        /**
         * 新生犬登记申请查询方法
         */
        me.findnewdogchipList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["semenBatchCode"] = me.semenBatchCode().trim();
            sendData["pedigreeCertified"] = me.pedigreeCertified().trim();
            sendData["semenCode"] = me.semenCode().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'dog/dogSemen',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("当前没有储备犬只精子！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });

        }
        //展示查看页
        me.showCszmask = function(){
        	$("#viewMask").css("display","block");
        }
        //关闭mask
        me.closemask  = function(type){
            $("#"+type).css("display","none");
        }
        $(function(){
            me.findnewdogchipList(false);
            me.member(userInfo.getMember());
        });
        me.getDetail = function(data){
            $("#viewMask").css("display","inline-block");
            util.sendAjax({
                url:'dog/dogSemen/'+data.id,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    me.detailData(json.data);
                    if(json.rc==0){
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }
        context.app.loading(false);
        context.app.isShop(false);
    }
});