//护照等级申请
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        var flag = false;
        var t;
        userInfo.refresh();
        //列表数据
        me.listData = ko.observableArray([]);
        //血统证书号
        me.identificationflag = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        me.verificationCodeDog = ko.observable("");
        //页码列表
        me.pageArray = ko.observableArray();
        me.detailData = ko.observable({});
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogownerchangeList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddogownerchangeList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogownerchangeList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogownerchangeList(false);
            }
            return false;
        }

        //护照等级贴纸申请
        me.addOwnerChange = function () {
            $("#newmask").css("display","block");
        }
        //关闭mask
        me.closemask  = function(type){
            $("#"+type).css("display","none");
        }
        //申请弹出窗验证
        me.checkBirthCode = function(){
            var newIdentificationflag = $("#newIdentificationflag").val();
            if(newIdentificationflag == ""){
                layer.msg("请输入血统证书号或芯片号");
                return
            }
            util.sendAjax({
                url: 'dog/dogStickerApply/checkByKey',
                data: {key:newIdentificationflag},
                async: false,
                loadFlag: true,
                type: 'GET',
                cache: false,
                success: function (data) {
                    if (data.rc == 0) {
                        newIdentificationflag = data.data.identificationFlag;
                        data.data.key = newIdentificationflag;
                        sessionStorage.setItem('dogGradeInfo',JSON.stringify(data));
                        location.href = location.href.split("#")[0]+"#/dog/passportGradeAdd?key="+newIdentificationflag
                    } else {
                        layer.msg("护照等级申请:" + data.msg);
                    }
                }
            });
        }

        /**
         * 护照等级列表查询方法
         */
        me.finddogownerchangeList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["identificationFlagAndPedigreeCertifiedLike"] = me.identificationflag().trim();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'dog/dogStickerApply',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list!=null && data.list.length>0) {
                            me.listData(data.list);
                        }else{
                            me.listData([]);
                            layer.msg("护照等级申请列表为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(), data.total, me.pageSize()));
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        };
        me.viewDetail = function(data,event){
            $('#viewnew').show();
            me.detailData({});
            util.sendAjax({
                url:'dog/dogStickerApply/getById/'+event.id,
                //data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.detailData(data.data);
                    }else{
                        layer.msg("信息查询失败:"+data.msg);
                    }
                }
            });
        }

        //初始化
        $(function(){
            me.finddogownerchangeList(false);
        });
        context.app.loading(false);
        context.app.isShop(false);
    }
});
