//查询可报名主赛事列表
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //比赛名称
        me.mainShowName = ko.observable("");
        //比赛地点
        me.showLocation = ko.observable("");
        //计时器
        me.timeRun = null;
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findShowAppraisalList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findShowAppraisalList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findShowAppraisalList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findShowAppraisalList(false);
            }
            return false;
        }
        /**
         * 主赛事列表查询方法
         */
        me.findShowAppraisalList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["mainShowName"] = me.mainShowName().trim();
            sendData["showLocation"] = me.showLocation().trim();
            sendData["pageSize"] = me.pageSize;
            sendData["pageNo"] = me.pageNo;
            util.sendAjax({
                url:'show/dogappraisalMain',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        if(data.list.length>0) {
                            var list = data.list;
                            $.each(list, function (index, item) {
                                var durTime = new Date(new Date(util.formatDateLong(item.closingTime).replace(/-/g,"/"))).getTime() - new Date().getTime();
                                var showTime = util.endTime(durTime);
                                item["showDurTime"] = ko.observable(showTime);
                            });
                            me.listData(list);
                        }else{
                            me.listData([]);
                            layer.msg("赛事列表为空！");
                        }
                        me.timeRun = setInterval(me.setTime,10000);
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),data.total,me.pageSize()));
                    }else{
                        layer.msg("赛事查询失败:"+data.msg);
                    }
                }
            });

        };
        /**
         * 申请前校验
         */
        me.validApply = function(data){
            util.sendAjax({
                url:'dog/dogappraisal/checkByMainShowId?mainShowId='+data.id,
                async:false,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.data.rc==true){
                       location.href = location.href.split("#")[0] + "#/dog/dogappraisaladd?id="+data.id;
                    }else{
                    	  layer.msg("申请失败:" + json.data.msg);
                    }
                }
            });
        }
        /**
         * 展现报名须知，参赛须知
         * @param type
         */
        me.showDiv = function(type){
            if(type=="sign"){
                if($("#showDivSign").css("display")=="none"){
                    $("#showDivSign").css("display","block");
                }else{
                    $("#showDivSign").css("display","none");
                }
            }else{
                if($("#showDivMess").css("display")=="none"){
                    $("#showDivMess").css("display","block");
                }else{
                    $("#showDivMess").css("display","none");
                }
            }
        }
        //截止日期
        me.setTime = function(){
            var list = me.listData();
            $.each(list,function(index,item){
                var durTime = new Date(new Date(util.formatDateLong(item.closingTime).replace(/-/g,"/"))).getTime() - new Date().getTime();
                var showTime = util.endTime(durTime);
                item.showDurTime(showTime);
            })
            me.listData(list);
        }
        $(function(){
            me.findShowAppraisalList(false);       
         });
        context.app.loading(false);
        context.app.isShop(false);
    }
});