//我的优惠劵
define(["knockout"], function(ko) {
  return function(context) {
    var me = this;
    me.dataList = ko.observableArray([]);
    //推荐编号
    me.shareCode = ko.observable("");
    //推广链接
    me.shareUrl = ko.observable("");
    //推广规则
    me.activityRuleHtml = ko.observable("");
    //分享code
    me.shareMemberCode = function() {
      const clipBoardContent = util.isVal(me.shareCode());
      util.copyText(clipBoardContent, function() {
        layer.msg("复制成功!", { time: 1000 });
      });
    };
    //分享url
    me.shareMyUrl = function() {
      const clipBoardContent = util.isVal(me.shareUrl());
      util.copyText(clipBoardContent, function() {
        layer.msg("复制成功!", { time: 1000 });
      });
    };

    me.initData = function() {
      var sendData = {};
      util.sendAjax({
        url: "open/shareRegister",
        data: sendData,
        async: false,
        type: "GET",
        cache: false,
        success: function(data) {
          console.log(data);
          if (data.rc == 0) {
            const { data: detailData } = data;
            me.shareCode(detailData.shareCode);
            me.shareUrl(detailData.shareUrl);
            me.activityRuleHtml(detailData.activityRuleHtml);

            if (detailData && detailData.shareList.length > 0) {
              me.dataList(detailData.shareList);
            } else {
              me.dataList([]);
            }
          } else {
            layer.msg("信息查询失败:" + data.msg);
          }
        }
      });
    };
    $(function() {
      me.initData(false);
    });
    context.app.loading(false);
    context.app.isShop(false);
  };
});
