<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>证书补做管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctxDc}/dogPedigreeCertifiedRedo">证书补做列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogPedigreeCertifiedRedo" action="${ctxDc}/dogPedigreeCertifiedRedo" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书编号：</label>
				<form:input path="originalPedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>补做类型：</label>
				<form:select path="changeType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_pedigree_certified_redo_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_pedigree_certified_redo_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
		</ul>
		<ul class="ul-form">
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>处理状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedRedo.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedRedo.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>原血统证书编号</th>
				<th>新血统证书编号</th>
				<th>犬主</th>
				<th>申请日期</th>
				<th>补做类型</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogPedigreeCertifiedRedo">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedRedo.originalPedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedRedo.currentPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedRedo.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedRedo.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedRedo.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:getDictLabel(dogPedigreeCertifiedRedo.changeType, 'dog_pedigree_certified_redo_type', '')}
				</td>
				<td style="color:${dogPedigreeCertifiedRedo.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedRedo.paymentState, 'user_payment_state', '')}
				</td>
				<td>
							${fns:getDictLabel(dogPedigreeCertifiedRedo.reviewState, 'dog_pedigree_certified_redo_review_state', '')}
				</td>
				<td>
							${fns:getDictLabel(dogPedigreeCertifiedRedo.processState, 'proccess_state', '')}
				</td>
				<td>
    				<a href="${ctxDc}/dogPedigreeCertifiedRedo/form?id=${dogPedigreeCertifiedRedo.id}">查看</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>