<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<meta http-equiv="X-UA-Compatible" content="IE=edge"/> <!-- ie兼容性 -->
<html>
<head>
	<title>会员信息</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					var avatar= $("#avatar").val();
					if(avatar==''){
						$.jBox.alert("请上传证件照!","提示")
					}else{
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						}
						$("#province").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});
			$("#kennel").hide();
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:会员登记</a></li>
	</ul>
	<div style = "clear:both;"></div>
	<form:form id="inputForm" modelAttribute="member" action="${ctxSchools}/schoolsMember/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="groomerType" value="reserve" />
		<form:hidden path="memberSite" value="" />
		<form:hidden path="freezeFlag" value="0"/>
		<sys:message content="${message}"/>	
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input id="birthday" name="birthday" type="text" readonly="readonly" maxlength="20" class="input-small Wdate required"
					onclick="WdatePicker({onpicking:function(dq){selectDatediff(dq.cal.getNewDateStr());},dateFmt:'yyyy-MM-dd',isShowClear:true,maxDate:'{%y-18}-%M-%d %H:%m:%s'});"/>
					<span class="help-inline"><font color="red">* 未满十八周岁请联系会员部注册</font> </span>
			</div>
		</div>
		<script type="text/javascript">
			function selectDatediff(a){
				if (a != "") {
					$.ajax({
						type: "POST",
		                dataType:"json",
		                url:"${ctxSchools}/schoolsMember/ageCheck?age="+a,
		                async: false,
		                error: function(request, textStatus, errorThrown) {
		                    alert("请求失败！");
		                },
		                success: function(data) {
		                	if(data.rc == false){
		                		$.jBox.alert("未满十八周岁请联系会员部注册!");
		                		$("#birthday").val("");
		                	}
		                }
					});
				}
			}
		</script>
		<div class="control-group">
			<label class="control-label">证件类型：</label>
			<div class="controls">
				<form:select path="cardType" class="input-small required">
					<form:option value="身份证">身份证</form:option>
					<form:option value="护照">护照</form:option>
				</form:select>
			</div>
		</div> 
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false" onBlur="checkCardNo()" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkCardNo() {
					cardNo = $("#cardNo").val();
					if (cardNo != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/cardNoCheck?param="+cardNo+"&type=1",
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("证件号已经存在!");
									$("#cardNo").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" onBlur="checkMobile()" maxlength="11" class="input-xlarge required isMobile"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkMobile() {
					mobile = $("#mobile").val();
					if (mobile != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/mobileCheck?param="+mobile,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("手机号已经存在!");
									$("#mobile").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge isZipCode" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge isQq"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge isPhone"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
					    console.log(json)
						if(json.rc==0){
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#city").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" onBlur="checkEmail()" maxlength="200" class="input-xlarge email required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkEmail() {
					email = $("#email").val();
					if (email != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/emailCheck?param="+email,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("邮箱已经存在!");
									$("#email").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#area").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label"></label>
			<div class="controls">

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
		<div class="control-group" style="width:50%">
			<label class="control-label">证件照：</label> 
			<div class="controls">
			 	<div class="file-portrait">
              		 <img id="avatarPreview" style="max-width:117px;max-height:150px;background-color: antiquewhite;border: 1px solid;" onclick="uploadImg()" src="${ctxStatic}/images/head.png">
              		 &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <font style="color:red;">参考样张--></font> &nbsp; &nbsp;&nbsp;&nbsp;&nbsp;
              		 <img id="review" style="max-width:117px;max-height:150px;"  src="${ctxStatic}/images/avatar_prospectus.jpg">
               </div>
                <p><a id="uploadImg" href="javascript:;" onclick="uploadImg()">点击上传证件照</a></p>
				<form:input path="avatar" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
				<!-- 文件上传成功的回调方法 -->
				<script type="text/javascript">
					function uploadSuccess(file,response){
						$("#avatar").val(response.id);
					}
			        function uploadImg(){
			        	layer.open({
			        		  type: 2,
			        		  title: '证件照上传',
			        		  shadeClose: true,
			        		  shade: 0.8,
			        		  area: ['480px', '340px'],
			        		  content:'${ctxSchools}/file/uploadPage'
			        		}); 
			        }
				</script>
				<span style="color:red;">证件照要求：请提交证书照片(正规白底免冠证件照) </br> 格式要求：白底、JPEG格式、3×4.2厘米、分辨率300dpi</span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				<form:hidden path="memberCardType" value="1010"/>
				<form:select path="memberType" class="input-small required" >
					<form:option value="basic" label="银卡会员"/>
				</form:select>
				<span><input  type="checkbox"  checked="checked" disabled="true"/>美容师预备会员</span>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属学校：</label>
			<div class="controls">
				<form:input path="ckuClub" value="${fns:getUser().name}" htmlEscape="false" readonly="true" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group" >
			<label class="control-label" style="width: 100px">会员开始日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly"  maxlength="20" class="input-medium "
					value="<fmt:formatDate value="${date}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" style="width: 100px">会员结束日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium"/>
			</div>
		</div>
		<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
		
		<div class="control-group">
			<label class="control-label" style="width: 100px">邮寄-证书类：</label>
			<div class="controls">
				<form:select path="deliveryCertified" class="input-small required " >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_certified')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label" style="width: 100px">邮寄-通知类：</label>
			<div class="controls">
				<form:select path="deliveryNotice" class="input-small required" >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_notice')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				 <form:input path="registrant" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true" value="${loginName}"/>
			 </div>
		 </div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>