<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:账户管理</a></li>
	</ul>
	<form:form  class="form-horizontal">
		<div>
			机构类型 : <font style="color:green;">${fns:getDictLabel(ti.schoolType, 'school_type', '')}</font>
		</div>
		<div>
			登录账号 : <font style="color:green;">${fns:getUser().name}</font>
		</div>
		<div>
			合作编号 : <font style="color:green;">${ti.schoolMemberCode}</font>
		</div>
		<div style="height: 20px;"></div>
		<a class="btn btn-primary"  href="${ctxSchools}/logout" target="_parent">安全退出</a>&nbsp;&nbsp;&nbsp;<a class="btn btn-primary"  href="${ctxSchools}/rePassword">修改密码</a>
		<div style="height: 20px;"></div>
		<div>
			学校中文名称 : <font style="color:green;">${ti.schoolNameCn }</font>
		</div>
		<div>
			学校英文名称 : <font style="color:green;">${ti.schoolNameEn  }</font>
		</div>
		<div>
			英文缩写 : <font style="color:green;">${ti.schoolShortName }</font>
		</div>
		<div style="height: 20px;"></div>
		<div>
			负责人会员号 : <font style="color:green;">${ti.memberCode }</font>
		</div>
		<div>
			负责人: <font style="color:green;">${ti.responsibler }</font>
		</div>
		<div>
			联系电话 : <font style="color:green;">${ti.telephone }</font>
		</div>
		<div style="height: 20px;"></div>
		<div  id="oldAddress">
			邮寄地址 : <span><font style="color:green;">${ti.address }</font></span>&nbsp;&nbsp;&nbsp;<span><input type="button" class="btn btn-primary" value="修 改" onclick="updateAddress()"/></span>
		</div>
		<div id="newAddress" style="display:none">
			邮寄地址 : 
		<span>
 			<select id="province"  class="input-xlarge ">
					<option value="">请选择省份</option>
					<c:forEach items="${province}" var="p">
						<option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</option>
					</c:forEach>
			</select>
			<select id="city"  class="input-xlarge ">
					<option value="">请选择城市</option>
					<c:forEach items="${city}" var="c">
						<option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</option>
					</c:forEach>
			</select>
			<input id="street" type="text"  maxlength="200" class="input-xlarge"/>
 		</span>
 		<span><input type="button" class="btn btn-primary" value="提交" onclick="saveAddress()"/></span>
 		<span><input type="button" class="btn btn-primary" value="返回" onclick="outAddress()"/></span>
		</div>
		<div style="height: 20px;"></div>			
		<div>
			截止日期 : <font style="color:green;"><fmt:formatDate value="${ti.member.memberEndDate}" pattern="yyyy-MM-dd"/></font>&nbsp;&nbsp;&nbsp;&nbsp;
			<%-- <a  class="btn btn-primary" href="${ctxSchools}/payment/schoolRenew?memberCode=${ti.schoolMemberCode}">续费</a> --%>
		</div>
		<div style="height: 20px;"></div>	
		<div>
			<c:if test="${empty fns:getUser().loginFlag || fns:getUser().loginFlag=='0'}">
				开放状态 : <font style="color:red;">关闭</font>
			</c:if>
			<c:if test="${fns:getUser().loginFlag=='1'}">
				开放状态 : <font style="color:green;">开放</font>
			</c:if>
		</div>
		<div style="height: 20px;"></div>	
		<div>
			账户余额 : <font style="color:green;">${ti.member.accountBalance }</font> &nbsp;&nbsp;&nbsp;&nbsp;<a  class="btn btn-primary" href="${ctxSchools}/schoolsAccountManagement/recharge">充值</a>
		</div>
</form:form>
 		<script>
 			function updateAddress(){
 				$("#oldAddress").hide();
 				$("#newAddress").show();
 			}
 			function outAddress(){
 				$("#oldAddress").show();
 				$("#newAddress").hide();
 			}
 			function saveAddress(){
 				var id = '${ti.id}';
				if($("#province").val()=='请选择省份' || $("#province").val()=='')
				{
					alert('请选择省份！！！');
					return false;	
				}
				if($("#city").val()=='')
				{
					alert('请选择城市！！！');
					return false;	
				}
				if($("#street").val()=='')
				{
					alert('街道不能为空！');
					return false;	
				}
				var province=$("#province").val();
				var city=$("#city").val();
				var street=$("#street").val();
 					 $.ajax({
	 						type: "POST",
			                dataType:"json",
			                url:"${ctxSchools}/schoolsAccountManagement/updateAddress",
			                data:{"id":id,"province":province,"city":city,"street":street},
			                async: true,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success:function(data){
			                	if(data.rc){
			                		window.location.href="${ctxSchools}/schoolsAccountManagement/account?id="+id;
			                	}
			                }
						});

 			}
 		
			$("#province").change(function(){
				var extId = $("#province").val();
				//异步请求数据
				var url="${ctxPartner}/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")
				
			});
		</script>
		
</body>
</html>