<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只激活管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a>我的门店管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="org" action="${ctxPartner}/org/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>门店名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>门店类型：</label>
				<form:select path="orgType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="chongjihemendian" label="宠集盒门店"/>
					<form:option value="catRenZheng" label="国际纯种犬猫认证服务中心"/>
				</form:select>
			</li>
			<li><label>门店状态：</label>
				<form:select path="state" class="input-small">
					<form:option value="all">全部</form:option>
					<form:option value="0">开放</form:option>
					<form:option value="1">关闭</form:option>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns" style="float:right"><a  class="btn btn-primary"  href="${ctxPartner}/org/form" >门店添加</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>门店名称</th>
				<th>门店类型</th>
				<th>门店编号</th>
				<th>截止日期</th>
				<th>当前状态</th>
				<th>审核状态</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="org">
			<tr>
				<td>
					${fns:escapeHtml(org.name)}
				</td>
				<td>
					${fns:getDictLabel(org.orgType, 'sys_org_type', '')}
				</td>
				<td>
					${fns:escapeHtml(org.memberCode)}
				</td>
				<td>
					<fmt:formatDate value="${org.endDate}" type="date" pattern="yyyy-MM-dd "/>

				</td>
				<td>
					<c:if test="${org.endDate gt currentDate}" > <font color="green">开放</font></c:if>
					<c:if test="${org.endDate lt currentDate}" > <font color="red">关闭</font> </c:if>
					<c:if test="${org.endDate eq currentDate}" > 今天关闭 </c:if>
				</td>
				<td>
					${fns:getDictLabel(org.shenHeState, 'review_state', '')}
				</td>
				<td>
					<a href="${ctxPartner}/org/view?id=${org.id}">查看</a>
					<c:if test="${org.shenHeState=='0' || org.shenHeState=='2'}">
						<a href="${ctxPartner}/org/editForm?id=${org.id}">编辑</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>