<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>宠集盒上架管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctxPartner}/fsbDogGrounding/">宠集盒上架列表</a></li>
    <li><a href="${ctxPartner}/fsbDogGrounding/form?operation=2">宠集盒上架添加</a></li>
</ul>
<form:form id="searchForm" modelAttribute="fsbDogGrounding" action="${ctxPartner}/fsbDogGrounding/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label style="width: 120px;">主人/电话/宠物名：</label>
            <form:input path="petOwnerMobile" htmlEscape="false" maxlength="30" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>宠物类型</th>
        <th>宠物主人</th>
        <th>宠主手机号</th>
        <th>宠物姓名</th>
        <th>出生日期</th>
        <th>芯片号</th>
        <th>上架状态</th>
        <th>操作</th>
        <th>详情</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="fsbDogGrounding">
        <tr>
            <td>
                    ${fns:getDictLabel(fsbDogGrounding.petType, 'pet_type', '')}
            </td>
            <td>
                    ${fsbDogGrounding.petOwner}
            </td>
            <td>
                    ${fsbDogGrounding.petOwnerMobile}
            </td>
            <td>
                    ${fsbDogGrounding.petName}
            </td>
            <td>
                <fmt:formatDate value="${fsbDogGrounding.petBirthdate}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${fsbDogGrounding.identificationFlag}
            </td>
            <td>
                <c:if test="${fsbDogGrounding.state=='0' }">
                    未上架
                </c:if>
                <c:if test="${fsbDogGrounding.state=='1' }">
                    已上架
                </c:if>
            </td>
            <td>
                <c:if test="${fsbDogGrounding.state=='0' }">
                    <a style="color:red;"
                       href="${ctxPartner}/fsbDogGrounding/shelf?id=${fsbDogGrounding.id}&state=1">上架</a>
                </c:if>
                <c:if test="${fsbDogGrounding.state=='1' }">
                    <a style="color:red;"
                       href="${ctxPartner}/fsbDogGrounding/shelf?id=${fsbDogGrounding.id}&state=0">下架</a>
                </c:if>
            </td>
            <td>
                <a href="${ctxPartner}/fsbDogGrounding/form?id=${fsbDogGrounding.id}&operation=1">查看</a>
                <a href="${ctxPartner}/fsbDogGrounding/form?id=${fsbDogGrounding.id}&operation=2">修改</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>