<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容学校邮寄管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/trainschool/groomerSchoolMail/">美容学校邮寄列表</a></li>
    <li class="active">美容学校邮寄添加</li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="groomerSchoolMail" action="${ctx}/trainschool/groomerSchoolMail/save"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <input type="hidden" name="schoolId" value="${trainingInstitution.id}">
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">美容学校：</label>
        <div class="controls">
                ${fns:escapeHtml(trainingInstitution.schoolNameCn)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">发放日期：</label>
        <div class="controls">
            <input name="releaseDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
                   value="<fmt:formatDate value="${groomerSchoolMail.releaseDate}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">发放数量：</label>
        <div class="controls">
            <form:input path="releaseNum" htmlEscape="false" maxlength="5" class="input-xlarge isDigits required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">地址：</label>
        <div class="controls">
                ${fns:escapeHtml(trainingInstitution.address)}
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="trainschool:groomer:edit">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>