<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>地方俱乐部信息统计</title>
<meta name="decorator" content="default" />

<script type="text/javascript">
	$(document).ready(function() {
	});
	function page(n, s) {
		$("#pageNo").val(n);
		$("#pageSize").val(s);
		$("#searchForm").submit();
		return false;
	}
	function SubmitByDate(date) {
		document.getElementById("nowDate").value = date
		document.getElementById("searchForm").submit();
	}
</script>
<style>
th, td {
	text-align: center !important;
	vertical-align: middle !important;
}
</style>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class=""><a href="${ctx}/statistics/club/clubStatistics">俱乐部统计信息</a></li>
		<li  class="active"><a href="#">俱乐部收费统计</a></li>
	</ul>
	<form id="searchForm" action="${ctx}/statistics/club/clubStatisticsList"
		method="post" class="breadcrumb form-search">
		<ul class="ul-form">
            <li><label>区域：</label> <select id="area" name="area"
				class="input-small selector" style="width: 177px">
					<option value="all" selected="selected">全部</option>
					<option value="110">北京办公室</option>
					<option value="410">郑州办公室</option>
					<option value="430">长沙办公室</option>
					<option value="330">杭州(平阳)办公室</option>
					<option value="220">长春办公室</option>
					<option value="500">重庆办公室</option>
			</select></li>
			<li><label>俱乐部名称：</label> <input id="name" name="name"
				type="text" maxlength="20" class="input " style="width: 163px"
				value="${name}" /></li>

		</ul>
		<ul class="ul-form">
			<li><label>开始时间：</label> <input id="startDate" name="startDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${startDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>

			<li><label>结束时间：</label> <input id="endDate" name="endDate"
				type="text" readonly="readonly" maxlength="20"
				class="input-medium Wdate" value="${endDate}"
				onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
			</li>
			<li style="padding-left: 72px" class="btns"><input
				id="btnSubmit" class="btn btn-primary"
				onclick="SubmitByDate('input')" type="submit" value="查询" /></li>
			<li class="btns"><input id="btnSubmit_current_month"
				class="btn btn-primary" type="button" value="本月"
				onclick="SubmitByDate('month')" /></li>
			<li class="btns"><input id="btnSubmit_current_yearh"
				class="btn btn-primary" type="button" value="本年"
				onclick="SubmitByDate('year')" /></li>
			<li><input id="nowDate" type="hidden" name="nowDate" value="" /></li>
		</ul>

	</form>
	<sys:message content="${message}" />
	<table id="contentTable"
		class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
                <th rowspan="2">区域</th>
				<th rowspan="2">省/直辖市</th>
				<th rowspan="2">俱乐部名字</th>
				<th rowspan="2">俱乐部会员号</th>
				<th colspan="2">基础会员年度登记费</th>
				<th colspan="2">专业会员初次注册费</th>
				<th colspan="2">专业会员年度登记费</th>
				<th colspan="2">犬舍名称初次注册费</th>
				<th colspan="2">犬舍年度登记费</th>
				<th colspan="2">建档服务费（新生幼犬）</th>
				<th colspan="2">新生幼犬CKU血统证书费</th>
				<th colspan="2">登记服务费（纯种DNA样本）</th>
				<th colspan="2">建档服务费（青年犬）</th>
				<th colspan="2">电子芯片埋置服务费</th>
				<th colspan="2">芯片费</th>
				<th colspan="2">信息管理费（信息匹配）</th>
				<th colspan="2">检测服务费（纯种犬DNA样本）</th>
                <th rowspan="3" onclick="orderByName('contentTable',31,'number')"><a href="javascript:;">金额合计</a></th>
			</tr>

			<tr>
				<th onclick="orderByName('contentTable',5,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',6,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',7,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',8,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',9,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',10,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',11,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',12,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',13,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',14,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',15,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',16,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',17,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',18,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',19,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',20,'number')"><a href="javascript:;">金额</a></th>
				<th onclick="orderByName('contentTable',21,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',22,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',23,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',24,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',25,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',26,'number')"><a href="javascript:;">金额</a></th>

				<th onclick="orderByName('contentTable',27,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',28,'number')"><a href="javascript:;">金额</a></th>
				<th onclick="orderByName('contentTable',29,'number')"><a href="javascript:;">数量</a></th>
				<th onclick="orderByName('contentTable',30,'number')"><a href="javascript:;">金额</a></th>
			</tr>

		</thead>
		<tbody id="clubContent">
			<c:forEach items="${results}" var="result">
				<tr>
                    <td>${result.area_name}</td>
					<td>${result.area_province}</td>
					<td>${result.name}</td>
					<td>${result.member_code}</td>
					<td><font color="blue">${result.member_basic_count}</font></td>
					<td><font color="brown">${result.member_basic_price}</font></td>
					<td><font color="blue">${result.member_professional_registration_count}</font></td>
					<td><font color="brown">${result.member_professional_registration_price}</font></td>
					<td><font color="blue">${result.member_professional_count}</font></td>
					<td><font color="brown">${result.member_professional_price}</font></td>
					<td><font color="blue">${result.kennel_registration_count}</font></td>
					<td><font color="brown">${result.kennel_registration_price}</font>
					<td><font color="blue">${result.kennel_year_count}</font></td>
					<td><font color="brown">${result.kennel_year_price}</font>
					<td><font color="blue">${result.certified_child_count}</font></td>
				    <td><font color="brown">${result.certified_child_price}</font></td>
					<td><font color="blue">${result.certified_child_cku_count}</font></td>
					<td><font color="brown">${result.certified_child_cku_price}</font></td>
					<td><font color="blue">${result.blood_count}</font></td>
					<td><font color="brown">${result.blood_price}</font></td>
					<td><font color="blue">${result.certified_count}</font></td>
					<td><font color="brown">${result.certified_price}</font></td>
					<td><font color="blue">${result.chip_embedment_count}</font></td>
					<td><font color="brown">${result.chip_embedment_price}</font></td>
					<td><font color="blue">${result.chip_count}</font></td>
					<td><font color="brown">${result.chip_price}</font></td>
                    <td><font color="blue">${result.information_management_count}</font></td>
					<td><font color="brown">${result.information_management_price}</font></td>
					<td><font color="blue">${result.test_count}</font></td>
					<td><font color="brown">${result.test_price}</font></td>
					<td>${result.member_basic_price + result.member_professional_registration_price +result.member_professional_price
                   +result.kennel_registration_price+result.kennel_year_price+result.certified_child_price
				+result.certified_child_cku_price+result.blood_price+result.certified_price+result.chip_embedment_price+result.chip_price+
                    result.information_management_price+result.test_price}</td>

				</tr>

			</c:forEach>
		</tbody>
<tbody>
			<tr>
				<td><b>合计</b></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>
				<td></td>

				<td id="allCount1"></td>
			</tr>
		</tbody>

		<div class="alert" role="alert"
			style="text-align: right; font-size: 15px;">${size}
			家地方俱乐部 总金额:<span id="allCount"></span>元
		</div>
	</table>
	<script type="text/javascript">
		if (document.getElementById('contentTable').getElementsByTagName('tr').length - 1 != 1) {
			var num = 4
			for (var i = num; i < 32 + num; i++) {
				calcTotal(document.getElementById('contentTable'), i, '');
			}
			var allCount = document.getElementById('allCount');
			var allCount1 = document.getElementById('allCount1').innerText;
			allCount.innerText = allCount1;

		}
		function calcTotal(table, column, text) {
			var trs = table.getElementsByTagName('tr');
			var start = 3, //忽略第一行的表头
			end = trs.length - 1;//忽略最后合计的一行
			var total = 0.00;
			for (var i = start; i < end; i++) {
				var td = trs[i].getElementsByTagName('td')[column];
				var t = parseFloat(td.innerText.substring(0,
						td.innerText.length));
				if (t)
					total = accAdd(t, total);
			}
			trs[end].getElementsByTagName('td')[column].innerHTML = '<b>'
					+ text + total + '</b>';
		}
		function accAdd(arg1, arg2) {
			var r1, r2, m;
			try {
				r1 = arg1.toString().split(".")[1].length
			} catch (e) {
				r1 = 0
			}
			try {
				r2 = arg2.toString().split(".")[1].length
			} catch (e) {
				r2 = 0
			}
			m = Math.pow(10, Math.max(r1, r2))
			return (arg1 * m + arg2 * m) / m
		}
	</script>
	<script>

function  orderByName(sTableID, iCol, sDataType) {
    var  oTable = document.getElementById(sTableID);
    var  oTBody = oTable.tBodies[0];
    var  colDataRows = oTBody.rows;

    var  aTRs =  new  Array;
    for  (  var  i = 0; i < colDataRows.length; i++) {
       aTRs[i] = colDataRows[i];
   }



    if  (oTable.sortCol == iCol) {
       aTRs.reverse();
   }  else  {

       aTRs.sort(generateCompareTRs(iCol, sDataType));
   }
    var  oFragment = document.createDocumentFragment();
    for  (  var  j = 0; j < aTRs.length; j++) {
		       oFragment.appendChild(aTRs[j]);
   }
   oTBody.appendChild(oFragment);
   oTable.sortCol = iCol;
}


/**
* 处理排序的字段类型
*
* @param sValue
*            字段值 默认为字符类型即比较ASCII码
* @param sDataType
*            字段类型 对于date只支持格式为mm/dd/yyyy或mmmm dd,yyyy(January 12,2004)
* @return
*/
function  convert(sValue, sDataType) {
    switch  (sDataType) {
    case   "int" :
        return  parseInt(sValue);
    case   "float" :
        return  parseFloat(sValue);
    case   "date" :
        return   new  Date(Date.parse(sValue));
	case	"number":
		return new Number(sValue)
    default :
        return  sValue.toString();
   }
}


/**
* 比较函数生成器
*
* @param iCol
*            数据行数
* @param sDataType
*            该行的数据类型
* @return
*/
function  generateCompareTRs(iCol, sDataType) {
    return   function  compareTRs(oTR1, oTR2) {

       vValue1 = convert(oTR1.cells[iCol].innerText, 'number');
       vValue2 = convert(oTR2.cells[iCol].innerText, 'number');

            return  vValue1 - vValue2;
   };
}
</script>
</body>
</html>