<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>CKU审查员管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //初始化
            typeChange('${showJudgeCertificate.certificateType}');
            if ('${showJudgeCertificate.id}' != '') {
                $("#certificateType").attr("disabled", "true");
            }

            $("#inputForm").validate({
                submitHandler: function (form) {
                    if ($("#certificateType").val() != '3') {
                        if ($("#signDate").val() == '') {
                            alert("签发日期不能为空");
                            return;
                        }
                        if ($("#endDate").val() == '') {
                            alert("有效日期不能为空");
                            return;
                        }
                    }
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });

        function typeChange(value) {
            if (value == "3") {
                $("#dogBreedNameDiv").hide();
                $("#dogBreedCodeDiv").hide();
                $("#signDateDiv").hide();
                $("#engDateDiv").hide();
                $("#groupDiv").show();
                $("#groomingGroupDiv").hide();
                $("#expirationDateVisibleFlagDiv").hide();
            } else if (value == "4") {
                $("#dogBreedNameDiv").show();
                $("#dogBreedCodeDiv").show();
                $("#signDateDiv").show();
                $("#engDateDiv").show();
                $("#groupDiv").hide();
                $("#groomingGroupDiv").hide();
                $("#expirationDateVisibleFlagDiv").hide();
            } else if (value == "8") {
            	$("#dogBreedNameDiv").hide();
                $("#dogBreedCodeDiv").hide();
                $("#signDateDiv").show();
                $("#engDateDiv").show();
                $("#groupDiv").hide();
                $("#groomingGroupDiv").show();
                $("#expirationDateVisibleFlagDiv").show();
            } else if (value == "9") {
                $("#dogBreedNameDiv").hide();
                $("#dogBreedCodeDiv").hide();
                $("#signDateDiv").show();
                $("#engDateDiv").show();
                $("#groupDiv").hide();
                $("#groomingGroupDiv").hide();
                $("#expirationDateVisibleFlagDiv").show();
            } else {
                $("#dogBreedNameDiv").hide();
                $("#dogBreedCodeDiv").hide();
                $("#signDateDiv").show();
                $("#engDateDiv").show();
                $("#groupDiv").hide();
                $("#groomingGroupDiv").hide();
                $("#expirationDateVisibleFlagDiv").hide();
            }
        }

        function delRow(obj, prefix){
            var id = $(prefix+"_id");
            var delFlag = $(prefix+"_delFlag");
            if (id.val() == ""){
                $(obj).parent().parent().remove();
            }else if(delFlag.val() == "0"){
                delFlag.val("1");
                $(obj).html("&divide;").attr("title", "撤销删除");
                $(obj).parent().parent().addClass("error");
            }else if(delFlag.val() == "1"){
                delFlag.val("0");
                $(obj).html("&times;").attr("title", "删除");
                $(obj).parent().parent().removeClass("error");
            }
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <shiro:hasPermission name="judgecertificate:showJudgeCertificate:view">
        <li><a href="${ctx}/judgecertificate/showJudgeCertificate/">CKU审查员列表</a></li>
    </shiro:hasPermission>
    <shiro:hasPermission name="judgecertificate:showJudgeCertificate:edit">
        <li class="active"><a href="${ctx}/judgecertificate/showJudgeCertificate/edit?id=${showJudgeCertificate.id}">CKU审查员${not empty showJudgeCertificate.id?'修改':'添加'}</a></li>
    </shiro:hasPermission>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="showJudgeCertificate"
           action="${ctx}/judgecertificate/showJudgeCertificate/save" method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">审查员类型：</label>
        <div class="controls">
            <form:select path="certificateType" class="input-xlarge " onchange="typeChange(this.value)"  style="width: 284px;">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('certificate_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">中文名：</label>
        <div class="controls">
            <form:input path="name" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">英文名：</label>
        <div class="controls">
            <form:input path="nameEn" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">证书号：</label>
        <div class="controls">
            <form:input path="judgeCertificate" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
     <div class="control-group" id="groomingGroupDiv">
        <label class="control-label">犬种组：</label>
        <div class="controls">
            <form:select path="groomingDogGroup" class="input-medium required" style="width: 284px;">
           	    <form:option value="">请选择</form:option>
                <form:options items="${fns:getDictList('grooming_judge_dog_group')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group" id="signDateDiv">
        <label class="control-label">签发日期：</label>
        <div class="controls">
            <input id="signDate" name="signDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate " style="width: 274px;"
                   value="<fmt:formatDate value="${showJudgeCertificate.signDate}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group" id="engDateDiv">
        <label class="control-label">有效日期：</label>
        <div class="controls">
            <input id="endDate" name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate " style="width: 274px;"
                   value="<fmt:formatDate value="${showJudgeCertificate.endDate}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否在页面显示：</label>
        <div class="controls">
            <form:select path="visibleFlag" class="input-medium" style="width: 284px;">
                <form:options items="${fns:getDictList('visible_flag')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <%--<c:if test="${showJudgeCertificate.certificateType =='8' || showJudgeCertificate.certificateType =='9'}">--%>
    <div class="control-group" id="expirationDateVisibleFlagDiv">
        <label class="control-label">有效日期是否展示：</label>
        <div class="controls">
            <form:select path="expirationDateVisibleFlag" class="input-medium" style="width: 284px;">
                <form:options items="${fns:getDictList('visible_flag')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <%--</c:if>--%>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false"  type="number" min="0" class="input-xlarge"/>
            <span class="help-inline">数字越大越靠前</span>
        </div>
    </div>
    <div class="control-group" id="groupDiv">
        <label class="control-label">犬种组信息：</label>
        <div class="controls">
            <table id="contentTable" class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th class="hide"></th>
                    <th>犬种证书号</th>
                    <th>通过犬种组</th>
                    <th>签发日期</th>
                    <th>有效日期</th>
                    <th>是否在页面展示</th>
                    <th width="10">&nbsp;</th>
                </tr>
                </thead>
                <tbody>
                <c:forEach items="${showJudgeCertificate.showJudgeCertificateDogGroupList}" var="showJudgeCertificateDogGroup" varStatus="vs">
                    <tr id="testDataChildList${vs.index}">
                        <td class="hide">
                            <input id="testDataChildList${vs.index}_id" name="showJudgeCertificateDogGroupList[${vs.index}].id" type="hidden" value="${showJudgeCertificateDogGroup.id}"/>
                            <input id="testDataChildList${vs.index}_delFlag" name="showJudgeCertificateDogGroupList[${vs.index}].delFlag" type="hidden" value="0"/>
                        </td>
                        <td>
                            <input name="showJudgeCertificateDogGroupList[${vs.index}].judgeCertificate" type="text" value="${showJudgeCertificateDogGroup.judgeCertificate}" maxlength="100" class="input-small"/>
                        </td>
                        <td>
                            <select id="referee${vs.index}" name="showJudgeCertificateDogGroupList[${vs.index}].groupNo" class="input-xlarge">
                                <c:forEach items="${fciShowGroupList}" var="dict">
                                    <option value="${fns:escapeHtml(dict.groupNo)}">${fns:escapeHtml(dict.judgeCertificateMian)}${dict.judgeCertificate}</option>
                                </c:forEach>
                            </select>
                            <script>
                                var referee = '${showJudgeCertificateDogGroup.groupNo}';
                                var refereeArray = referee.split(",");
                                $.each(refereeArray, function(i,val) {
                                    $('#referee${vs.index}').find("option[value='"+val+"']").attr("selected",true);
                                });
                                $('#referee${vs.index}').trigger("change");
                            </script>
                        </td>
                        <td>
                            <input name="showJudgeCertificateDogGroupList[${vs.index}].signDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate "
                                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.signDate}" pattern="yyyy-MM-dd"/>"
                                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
                        </td>
                        <td>
                            <input name="showJudgeCertificateDogGroupList[${vs.index}].endDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate "
                                   value="<fmt:formatDate value="${showJudgeCertificateDogGroup.endDate}" pattern="yyyy-MM-dd"/>"
                                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
                        </td>
                        <td>
                            <select id="visibleFlag${vs.index}" name="showJudgeCertificateDogGroupList[${vs.index}].visibleFlag" class='input-xlarge' style="width: 100px;">
                                <option value="0" ${'0'==showJudgeCertificateDogGroup.visibleFlag?'selected':''}>否</option>
                                <option value="1" ${'1'==showJudgeCertificateDogGroup.visibleFlag?'selected':''} >是</option>
                            </select>
                        </td>
                        <%--<td>
                            <select id="expirationDateVisibleFlag${vs.index}" name="showJudgeCertificateDogGroupList[${vs.index}].expirationDateVisibleFlag" class='input-xlarge' style="width: 100px;">
                                <option value="0" ${'0'==showJudgeCertificateDogGroup.expirationDateVisibleFlag?'selected':''}>否</option>
                                <option value="1" ${'1'==showJudgeCertificateDogGroup.expirationDateVisibleFlag?'selected':''} >是</option>
                            </select>
                        </td>--%>
                        <td class="text-center" width="10">
                            <span class="close" onclick="delRow(this, '#testDataChildList${vs.index}')" title="删除">&times;</span>
                        </td>
                    </tr>
                </c:forEach>
                </tbody>
                <tfoot>
                <tr><td colspan="8"><a href="javascript:" onclick="add();" class="btn btn-primary">新增</a></td></tr>
                </tfoot>
            </table>
            <script type="text/javascript">
                var data = ${fns:toJson(showJudgeCertificate.showJudgeCertificateDogGroupList)};
                var i = data.length-1;
                function add(){
                    i=i+1;
                    var htm = "<tr id='testDataChildList"+i+"'>"+
                            "<td class='hide'>"+
                            "<input id='testDataChildList"+i+"_id' name='showJudgeCertificateDogGroupList["+i+"].id' type='hidden' value=''/>"+
                            "<input id='testDataChildList"+i+"_delFlag' name='showJudgeCertificateDogGroupList["+i+"].delFlag' type='hidden' value='0'/>"+
                            "</td>"+
                            "<td>"+
                            "<input name='showJudgeCertificateDogGroupList["+i+"].judgeCertificate' type='text' value='' maxlength='100' class='input-small '/>"+
                            "</td>"+
                            "<td>"+
                            "<select id='showJudgeCertificateDogGroupList["+i+"].groupNo' name='showJudgeCertificateDogGroupList["+i+"].groupNo' class='input-xlarge'>"+
                            "<c:forEach items='${fciShowGroupList}' var='dict'>"+
                            "<option value='${fns:escapeHtml(dict.groupNo)}'>${fns:escapeHtml(dict.judgeCertificateMian)}"+"<br/>"+"${dict.judgeCertificate}</option>"+
                            "</c:forEach>"+
                            "</select>"+
                            "</td>"+
                            "<td>"+
                            "<input name='showJudgeCertificateDogGroupList["+i+"].signDate' type='text' readonly='readonly' maxlength='20' class='input-mini Wdate '"+
                            "value='<fmt:formatDate value='${showJudgeCertificateDogGroup.signDate}' pattern='yyyy-MM-dd'/>'"+
                            "onclick="+"WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"+">"+
                            "</td>"+
                            "<td>"+
                            "<input name='showJudgeCertificateDogGroupList["+i+"].endDate' type='text' readonly='readonly' maxlength='20' class='input-mini Wdate '"+
                            "value='<fmt:formatDate value='${showJudgeCertificateDogGroup.endDate}' pattern='yyyy-MM-dd'/>'"+
                            "onclick="+"WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"+">"+
                            "</td>"+
                            "<td>"+
                            "<select id='visibleFlag"+i+"' name='showJudgeCertificateDogGroupList["+i+"].visibleFlag' class='required input-xlarge' style='width: 100px;'>"+
                            "<option value=\"1\">是</option>"+
                            "<option value=\"0\">否</option>"+
                            "</select>"+
                            "</td>"+

                            <%--"<shiro:hasPermission name='test:testDataMain:edit'>"+--%>
                            "<td class='text-center' width='10'>"+
                            "<span class='close' onclick="+"\""+"delRow(this,'#testDataChildList"+i+"')"+"\""+" title='删除'>&times;</span>"+
                            "</td>"+
                            <%--"</shiro:hasPermission>"+--%>
                            "</tr>";
                    $("#showJudgeCertificateDogGroupList["+i+"].visibleFlag").trigger("create");
                    $("#contentTable").append(htm);
                    $("select").select2();
                }
            </script>
        </div>
    </div>
    <div class="control-group" id="dogBreedNameDiv">
        <label class="control-label">通过犬种：</label>
        <div class="controls">
            <form:input path="dogBreedName" htmlEscape="false" maxlength="10"  class="input-xlarge"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group" id="dogBreedCodeDiv">
        <label class="control-label">FCI编码：</label>
        <div class="controls">
            <form:input path="dogBreedCode" htmlEscape="false" maxlength="10"  class="input-xlarge"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="judgecertificate:showJudgeCertificate:edit">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>