<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>项目管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/project/ckuProject/">项目列表</a></li>
		<shiro:hasPermission name="project:ckuProject:edit"><li><a href="${ctx}/project/ckuProject/form">项目添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="ckuProject" action="${ctx}/project/ckuProject/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>项目名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="128" class="input-medium"/>
			</li>
			<li><label>项目部门：</label>
				<sys:treeselect id="deptId" name="deptId" value="${ckuProject.deptName}" labelName="deptName" labelValue="${ckuProject.deptName}"
					allowInput="true" onlyBtn="true" title="部门" url="/sys/office/treeData?type=2" allowClear="true" cssClass="input-medium" notAllowSelectParent="true"/>
			</li>
			<li><label>项目负责人：</label>
				<sys:treeselect id="adminId" name="adminId" value="${ckuProject.adminName}" labelName="adminName" labelValue="${ckuProject.adminName}"
					allowInput="true" onlyBtn="true" title="用户" url="/sys/office/treeData?type=3" allowClear="true" cssClass="input-medium" notAllowSelectParent="true"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>项目名称</th>
				<th>所属部门</th>
				<th>项目负责人</th>
				<th>项目开始时间</th>
				<th>项目结束时间</th>
				<th>创建时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="ckuProject">
			<tr>
				<td>
					${ckuProject.name}
				</td>
				<td>
					${ckuProject.deptName}
				</td>
				<td>
					${ckuProject.adminName}
				</td>
				<td style="text-align: center;">
					<c:if test="${not empty ckuProject.startTime}">
						<fmt:formatDate value="${ckuProject.startTime}" pattern="yyyy"/>年第${ckuProject.startWeek}周
						<fmt:formatDate value="${ckuProject.startTime}" pattern="(yyyy/MM/dd)"/>
					</c:if>
					<c:if test="${empty ckuProject.startTime}">-</c:if>
				</td>
				<td style="text-align: center;">
					<c:if test="${not empty ckuProject.endTime}">
						<fmt:formatDate value="${ckuProject.endTime}" pattern="yyyy"/>年第${ckuProject.endWeek}周
						<fmt:formatDate value="${ckuProject.endTime}" pattern="(yyyy/MM/dd)"/>
					</c:if>
					<c:if test="${empty ckuProject.endTime}">-</c:if>
				</td>
				<td>
					<fmt:formatDate value="${ckuProject.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
   					<a href="${ctx}/project/ckuProject/view?id=${ckuProject.id}">查看</a>
    				<shiro:hasPermission name="project:ckuProject:edit">
    					<a href="${ctx}/project/ckuProject/form?id=${ckuProject.id}">修改</a>
						<a href="${ctx}/project/ckuProject/delete?id=${ckuProject.id}" onclick="return confirmx('确认要删除该技术项目表吗？', this.href)">删除</a>
    				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>