<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>俱乐部采样包物资明细</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<shiro:hasPermission name="org:orgSampling:view"><li><a href="${ctx}/org/orgSampling/groupList?orgId=${org.id}">合作机构采样包管理</a></li></shiro:hasPermission>
		<shiro:hasPermission name="org:orgSampling:view"><li class="active"><a href="${ctx}/org/orgSampling/detailList?batchNum=${batchNum}&orgId=${org.id}">俱乐部采样包物资明细</a></li></shiro:hasPermission>
		<shiro:hasPermission name="org:orgSampling:add"><li><a href="${ctx}/org/orgSampling/addForm?orgId=${org.id}">合作机构采样包发放</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="orgSampling" action="${ctx}/org/orgSampling/detailList?batchNum=${batchNum}&orgId=${org.id}" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>采样包编号：</label>
				<form:input path="samplingCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬只编号</th>
				<th>采样包编号</th>
				<th>机构名称</th>
				<th>发放时间</th>
				<th>采样包状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="vo">
			<tr>
				<td>
						${vo.dogCode}
				</td>
				<td>
						${vo.samplingCode}
				</td>
				<td>
						${org.name}
				</td>
				<td>
					<fmt:formatDate value="${vo.postDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:choose>
						<c:when test="${vo.flowState < 2}">
							${fns:getDictLabel(vo.bindType, 'bind_type', '')}
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(vo.flowState, 'sampling_flow_state', '')}
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<shiro:hasPermission name="org:orgSampling:del">
						<c:if test="${vo.flowState == 1}">
							<a href="${ctx}/org/orgSampling/delete?id=${vo.id}&batchNum=${batchNum}&orgId=${org.id}" onclick="return confirmx('确认要删除该采样包吗？', this.href)">删除</a>
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>