<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍所有人变更管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function save(){
			var frm = $("#inputForm");
			var dataPara = util.getFormJson(frm);
			$.ajax({
				url: '${ctx}/kennel/kennelOwnerChange/orderSave',
				type: 'POST',
				data: dataPara,
				success: function(json){
					if(json.code == '-1'){
						alert(json.msg);
						return false;
					}
					parent.isYes = true;
					parent.layer.closeAll();
				}
			});
		}
		function closeLayer(){
			parent.isYes = false;
			parent.layer.closeAll();
		};
		
		function getKennelName(){
			var originOwnerMemberCode=$("#originOwnerMemberCode").val();
			if (originOwnerMemberCode!="") {
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/kennel/kennelOwnerChange/getKennelName",
	                async: false,
	                data : {'originOwnerMemberCode':originOwnerMemberCode},
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
						if(data.code == '-1'){
							alert(data.msg);
							return false;
						}
		                
	                	$('#kennelName').val(data.kennelName);
	                	$("#kennelCode").val(data.kennelCode);
	                	$("#kennelCodeStr").val(data.kennelCode);
	               }
				});
			}
		}
		
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="kennelOwnerChange"  method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="runningNumber" value="${runningNumber}"/>
		<form:hidden path="paymentMoney" value="${paymentMoney}"/>
		<form:hidden path="chargingItemId" value="${chargingItemId}"/>
		<form:hidden path="kennelCodeStr" />
 
 
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">原犬舍所有人会员号：</label>
			<div class="controls">
				<form:input path="originOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
				<input id="btnCancel" class="btn btn-primary" type="button" value="查询" onclick="getKennelName()"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍编号：</label>
			<div class="controls">
				<input id="kennelCode" type="text" class="input-xlarge " readonly="readonly">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍名称：</label>
			<div class="controls">
				<input id="kennelName" type="text" class="input-xlarge " readonly="readonly">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">新犬舍所有人会员号：</label>
			<div class="controls">
				<form:input path="newOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>
			<input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
		</div>
	</form:form>
</body>
</html>