<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬舍管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			var bo;
			$("#name").blur(function(){
				var name = encodeURI($("#name").val());
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctx}/kennel/kennel/nameCheck?name="+name,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                    alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc == false){
	                		bo = data.rc;
	                		$("#nameError").html('犬舍中文名已经存在！');
							$("#nameError").show();
							$("#name").attr("value", '');
	                	}else{
	                		bo = data.rc;
	                	}
	                }
				})
			});
			$("#name").focus(function(){
				$("#nameError").hide();
			})
			$("#inputForm").validate({
				submitHandler: function(form){
					if(bo == false){
						alert(bo);
						$("#nameError").attr("value", '犬舍中文名已经存在！');
						$("#nameError").show();
						$("#name").attr("value", '');
					}else{
						loading('正在提交，请稍等...');
						form.submit();
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<%-- <link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/> --%>
</head>
<body>
	<ul class="nav nav-tabs">
		<%-- <li><a href="${ctx}/kennel/kennel/">犬舍列表</a></li>
		<li class="active"><a href="${ctx}/kennel/kennel/form?memberCode=${kennel.memberCode}">犬舍<shiro:hasPermission name="kennel:kennel:edit">${not empty kennel.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="kennel:kennel:edit">查看</shiro:lacksPermission></a></li> --%>
		<li>犬舍添加</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="kennel" action="${ctx}/kennel/kennel/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员姓名：</label>
			<div class="controls">
				<form:input path="member.name" htmlEscape="false" maxlength="100" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍编号：</label>
			<div class="controls">
				<form:input path="kennelCode" value="${kennel.member.memberCode }" readonly="true"  htmlEscape="false" minlength="3" maxlength="30" class="input-xlarge "/>
			</div>
		</div> 
		<div class="control-group">
			<label class="control-label">FCI犬舍编号：</label>
			<div class="controls">
				<form:input path="fciKennelCode"  htmlEscape="false"  maxlength="30" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="6" required="true" class="input-xlarge "/>
				<span class="help-inline"><font color="red">*</font> </span>
				<span id="nameError" style="color:red;display:none" class="error"></span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false"  maxlength="30" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI英文名：</label>
			<div class="controls">
				<form:input path="fciName" htmlEscape="false"  maxlength="30" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI备用英文名：</label>
			<div class="controls">
				<form:input path="fciNameBackup" htmlEscape="false"  maxlength="30" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">中文犬舍地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">英文犬舍地址：</label>
			<div class="controls">
				<form:input path="fciKennelAddress" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬舍类型：</label>
			<div class="controls">
				<form:select path="type" required="true" class="input-xlarge required">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('kennel_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
	<%-- 	<div class="control-group">
			<label class="control-label">犬舍中文审核：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>		
		<div class="control-group">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				<form:textarea path="reviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">FCI犬舍审核：</label>
			<div class="controls">
				<form:select path="fciReviewState" class="input-xlarge ">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">未通过原因：</label>
			<div class="controls">
				<form:textarea path="fciReviewRemark" htmlEscape="false" rows="2" maxlength="200" class="input-xxlarge "/>
			</div>
		</div> --%>
		<!-- <div style="clear:both;"/> -->
		<div class="form-actions">
			<shiro:hasPermission name="kennel:kennel:add"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>