<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>资格证书管理</title>
	<meta name="decorator" content="default"/>

</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerQualificationCertificate/view?id=${handlerQualificationCertificate.id}">资格证书查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="handlerQualificationCertificate"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<h3>证书信息</h3>		
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
			${fns:escapeHtml(handlerQualificationCertificate.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">取证日期：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerQualificationCertificate.takeCertificateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				${fns:escapeHtml(handlerQualificationCertificate.certificateCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				${fns:getDictLabel(handlerQualificationCertificate.certificateLevelEn,'groomer_test_level','')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<fmt:formatDate value="${handlerQualificationCertificate.issueDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>赛事信息</h3>	
		<div class="control-group">
			<label class="control-label">赛事编号：</label>
			<div class="controls">
				${fns:escapeHtml(handlerQualificationCertificate.handlerRegister.showCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">参赛级别：</label>
			<div class="controls">
				${fns:getDictLabel(handlerQualificationCertificate.handlerRegister.showLevel,'groomer_test_level','')}			
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">成绩：</label>
			<div class="controls">
				${fns:getDictLabel(handlerQualificationCertificate.handlerRegister.grade, 'handler_grade', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">付款的状态：</label>
			<div class="controls">
				${fns:getDictLabel(handlerQualificationCertificate.paymentState, 'user_payment_state', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
			${fns:escapeHtml(handlerQualificationCertificate.remarks)}
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>