<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>FCI资格证书管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#btnExport").click(function () {
                top.$.jBox.confirm("确认要导出数据吗？", "系统提示", function (v, h, f) {
                    if (v == "ok") {
                        $("#searchForm").attr("action", "${ctx}/groomer/fciGroomerQualificationCertificate/export");
                        $("#searchForm").submit();
                    }
                }, {buttonsFocus: 1});
                top.$('.jbox-body .jbox-icon').css('top', '55px');
            });
        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").attr("action", "${ctx}/groomer/fciGroomerQualificationCertificate/list");
            $("#searchForm").submit();
            return false;
        }

        //批量提醒
        function todo() {
            var ids = "";
            $(".certificateiId").each(function () {
                var id = $(this).val();
                ids += id + ',';
            });
            if (ids != "") {
                $.ajax({
                    type: "POST",
                    url: ctx + "/groomer/fciGroomerQualificationCertificate/batchReminder",
                    data: {'ids': ids},
                    dataType: 'json',
                    success: function (json) {
                        $.jBox.alert("提醒成功！", "提示");
                    }
                });
            } else {
                $.jBox.alert("无提醒任务！", "提示");
            }
        }

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/groomer/fciGroomerQualificationCertificate/list">Fci资格证书管理</a></li>
</ul>
<form:form id="searchForm" modelAttribute="fciGroomerQualificationCertificate"
           action="${ctx}/groomer/fciGroomerQualificationCertificate/list" method="post" class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <input id="certificateType" name="certificateType" type="hidden" value="${fciGroomerQualificationCertificate.certificateType}"/>
	  <ul class="ul-form">
        <li><label>会员号/姓名：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>赛事编号：</label>
            <form:input path="groomerRegister.showCode" htmlEscape="false" maxlength="100" class="input-medium"/>
        </li>
        <li><label>报名序号：</label>
            <form:input path="groomerRegister.registerCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>证书编号：</label>
            <form:input path="fciCertificateCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>成绩：</label>
            <form:select path="groomerRegister.grade" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('Grade')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>参赛级别：</label>
            <form:select path="levelEn" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('groomer_test_level')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>FCI证书缴费状态:</label>
            <form:select path="paymentState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <%--<li><label>处理状态：</label>
            <form:select path="proccessState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>--%>
        <li><label>FCI打印状态：</label>
            <form:select path="printState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('print_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>培训学校：</label>
             <form:input path="groomerRegister.schoolNameCn" htmlEscape="false" maxlength="100" class="input-medium"/>
        </li>
        
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"
                                onclick="return page();"/></li>
        <li class="btns"><shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:edit"><input
                id="btnListSubmit" class="btn btn-primary" type="button" value="批量提醒"
                onclick="todo()"/></shiro:hasPermission></li>
        <li class="btns"><shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:export">
            <button id="btnExport" type="button" class="btn btn-primary">导出</button>
        </shiro:hasPermission></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>报名序号</th>
        <th>会员号</th>
        <th>姓名</th>
        <th>美容师类型</th>
        <th>性别</th>
        <th>移动电话</th>
        <th>培训学校</th>
        <th>比赛犬种</th>
        <th>赛事名称</th>
        <th>赛事编号</th>
        <th>考试级别</th>
        <th>成绩</th><%--
        <th>笔试成绩</th>--%>
        <th>FCI资格证书号</th>
        <th>FCI证书申领缴费</th>
        <th>申领倒计时</th>
        <th>FCI操作</th><%--
        <th>证书来源</th>--%>
        <th>查看</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="fciGroomerQualificationCertificate">
        <tr>
            <c:choose>
                <c:when test="${fciGroomerQualificationCertificate.paymentState=='1' }">
                    <td style="display:none">
                        <input class="certificateiId" type="text" style="display:none"
                               value="${fns:escapeHtml(fciGroomerQualificationCertificate.id)}"/>
                    </td>
                </c:when>
            </c:choose>
            <td>
                    ${fns:escapeHtml(fciGroomerQualificationCertificate.groomerRegister.registerCode)}
            </td>
            <td>
                <a href="${ctx}/sys/user/member/form?id=${fciGroomerQualificationCertificate.member.id}">
                        ${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode)}
                </a>
            </td>
            <td>
                    ${fns:escapeHtml(fciGroomerQualificationCertificate.member.name)}
            </td>
            <td>
                    ${fns:getDictLabels(fciGroomerQualificationCertificate.member.groomerType, 'user_groomer_type', '无')}
            </td>
            <td>
                    ${fns:getDictLabel(fciGroomerQualificationCertificate.member.gender,'user_gender','')}
            </td>
            <td>
                    ${fns:escapeHtml(fciGroomerQualificationCertificate.member.mobile)}
            </td>
            <td>
                    ${fn:replace(fciGroomerQualificationCertificate.groomerRegister.schoolNameCn, ",", "  ")}
            </td>
            <td>
                    ${fn:replace(fciGroomerQualificationCertificate.groomerRegister.showDogBreed, ",", "  ")}
            </td>
            <td>
                    ${fns:escapeHtml(fciGroomerQualificationCertificate.groomerShow.showName)}
            </td>
            <td>
                    ${fns:escapeHtml(fciGroomerQualificationCertificate.groomerRegister.showCode)}
            </td>
            <td>
                    ${fns:getDictLabel(fciGroomerQualificationCertificate.levelEn, 'groomer_test_level', '')}
            </td>
            <td>
                <c:choose>
                    <c:when test="${fciGroomerQualificationCertificate.groomerRegister.grade=='0' or fciGroomerQualificationCertificate.groomerRegister.grade=='1'}">
                        <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.groomerRegister.grade, 'Grade', '')}</font>
                    </c:when>
                    <c:otherwise>
                        <font color="green">${fns:getDictLabel(fciGroomerQualificationCertificate.groomerRegister.grade, 'Grade', '')}</font>
                    </c:otherwise>
                </c:choose>
            </td>
            <%--<td>
                <c:if test="${fciGroomerQualificationCertificate.sourceType=='1'}">
                    <c:choose>
                        <c:when test="${fciGroomerQualificationCertificate.groomerRegister.gradeWrite=='0'}">
                        <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.groomerRegister.gradeWrite, 'grade_write', '')}</font>
                        </c:when>
                        <c:when test="${fciGroomerQualificationCertificate.groomerRegister.gradeWrite=='1'}">
                            <font color="green">${fns:getDictLabel(fciGroomerQualificationCertificate.groomerRegister.gradeWrite, 'grade_write', '')}</font>
                        </c:when>
                        <c:otherwise>
                            <font color="red">录入成绩</font>
                        </c:otherwise>
                    </c:choose>
                </c:if>
            </td>--%>

                <td>
                    <%--<shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:create">
                    <c:if test="${empty fciGroomerQualificationCertificate.fciCertificateCode && fciGroomerQualificationCertificate.paymentState=='2'}">
                        <a href="${ctx}/groomer/groomerQualificationCertificate/createCode?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}">点击生成</a>
                    </c:if>
                    <c:if test="${not empty fciGroomerQualificationCertificate.fciCertificateCode}">
                        ${fns:escapeHtml(fciGroomerQualificationCertificate.fciCertificateCode)}
                    </c:if>
                    </shiro:hasPermission>--%>
                </td>

                <td>
                    <shiro:hasPermission name="finance:deductCost:deductCost">
                        <%--<c:choose>
                            <c:when test="${groomerQualificationCertificate.paymentState=='1' && groomerQualificationCertificate.levelEn=='C' &&  groomerQualificationCertificate.schoolType!=null }">
                                <font color="red">${fns:getDictLabel(groomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                            </c:when>--%>
                            <%--<c:when test="${fciGroomerQualificationCertificate.paymentState=='1' && fciGroomerQualificationCertificate.levelEn=='B' }">
                                <a onclick="util.pay('${fns:escapeHtml(fciGroomerQualificationCertificate.id)}','fci_groomer_qualification_certificate@B',1,'','${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode)}')">
                                    <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                                </a>
                            </c:when>
                            <c:when test="${fciGroomerQualificationCertificate.paymentState=='1' && fciGroomerQualificationCertificate.levelEn=='C' }">
                                <a onclick="util.pay('${fns:escapeHtml(fciGroomerQualificationCertificate.id)}','fci_groomer_qualification_certificate@C',1,'','${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode)}')">
                                    <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                                </a>
                            </c:when>
                            <c:when test="${fciGroomerQualificationCertificate.paymentState=='1' && fciGroomerQualificationCertificate.levelEn=='A' }">
                                <a onclick="util.pay('${fns:escapeHtml(fciGroomerQualificationCertificate.id)}','fci_groomer_qualification_certificate@A',1,'','${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode)}')">
                                    <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                                </a>
                            </c:when>
                            &lt;%&ndash;<c:when test="${fciGroomerQualificationCertificate.paymentState=='1' && fciGroomerQualificationCertificate.levelEn=='MASTER' }">
                                <a onclick="util.pay('${fns:escapeHtml(fciGroomerQualificationCertificate.id)}','fci_groomer_qualification_certificate@M',1,'','${fns:escapeHtml(fciGroomerQualificationCertificate.memberCode)}')">
                                    <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                                </a>
                            </c:when>&ndash;%&gt;
                            <c:otherwise>
                                <font color="green">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                            </c:otherwise>
                        </c:choose>
--%>
                        <c:choose>
                            <%--<c:when test="${groomerQualificationCertificate.paymentState=='1' && groomerQualificationCertificate.levelEn=='C' &&  groomerQualificationCertificate.schoolType!=null }">
                                <font color="red">${fns:getDictLabel(groomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                            </c:when>--%>
                            <c:when test="${fciGroomerQualificationCertificate.paymentState=='1'}">
                                <a onclick="util.payBusinessOrderByDataId('ca76211803c24e57bd02ac05ac1c2d52','${fciGroomerQualificationCertificate.memberCode}','${fciGroomerQualificationCertificate.id}')">
                                    <font color="red">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                                </a>
                            </c:when>
                            <c:otherwise>
                                <font color="green">${fns:getDictLabel(fciGroomerQualificationCertificate.paymentState,'user_payment_state','')}</font>
                            </c:otherwise>
                        </c:choose>
                    </shiro:hasPermission>
                </td>

            <td>
                <c:choose>
                    <c:when test="${fciGroomerQualificationCertificate.paymentState =='2'}">
                        <input class="gradeTime" type="text" style="display:none" value=""/>
                    </c:when>
                    <c:otherwise>
                        <input class="gradeTime" type="text" style="display:none"
                               value="<fmt:formatDate value="${fciGroomerQualificationCertificate.groomerShow.endTime}" pattern="yyyy/MM/dd HH:mm:ss"/>"/>
                        <div class="colockbox" id="colockbox1"
                             style="width: 100%;  font-family: arial; text-align: center;">
                            <span class="day" style="color:red">00</span>天
                            <span class="hour" style="color:red">00</span>时
                            <span class="minute" style="color:red">00</span>分
                        </div>
                    </c:otherwise>
                </c:choose>
            </td>
            <td>
                <c:choose>
                    <c:when test="${fciGroomerQualificationCertificate.paymentState=='2' && fciGroomerQualificationCertificate.printState=='0' }">
                        <shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:print">
                            <a href="${ctx}/groomer/fciGroomerQualificationCertificate/print?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}">FCI证书打印</a>
                        </shiro:hasPermission>
                    </c:when>
                    <c:when test="${fciGroomerQualificationCertificate.paymentState=='2' && fciGroomerQualificationCertificate.printState=='1' }">
                        <shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:resetPrint">
                            <a href="${ctx}/groomer/groomerQualificationCertificate/fci/resetPrint?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}">重置FCI证书打印</a>
                        </shiro:hasPermission>
                    </c:when>
                    <c:when test="${fciGroomerQualificationCertificate.paymentState=='1'}">
                        <shiro:hasPermission name="groomer:fciGroomerQualificationCertificate:edit">
                            <a href="${ctx}/groomer/fciGroomerQualificationCertificate/reminderOne?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}"
                               onclick="return confirmx('确认要提醒吗？', this.href)">提醒领取资格证书</a>
                        </shiro:hasPermission>
                    </c:when>
                </c:choose>
            </td>
            <%--<td>
                ${fns:escapeHtml(fciGroomerQualificationCertificate.sourceType)}
            </td>--%>
            <td>
                <a href="${ctx}/groomer/fciGroomerQualificationCertificate/viewForm?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}">查看</a>
                <a href="${ctx}/groomer/fciGroomerQualificationCertificate/editForm?id=${fns:escapeHtml(fciGroomerQualificationCertificate.id)}">编辑</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
<script type="text/javascript">

    $(function () {
        $(".gradeTime").each(function () {
            var gradeTime = $(this).val();
            console.log(gradeTime);
            countDown(gradeTime, $(this).next());
        });


    });

    function countDown(time, timeArea) {
        var end_time = new Date(time).getTime() + 61 * 24 * 60 * 60 * 1000;
        var day_elem = timeArea.find('.day');
        var hour_elem = timeArea.find('.hour');
        var minute_elem = timeArea.find('.minute');
        //var end_time = new Date(time).getTime(),//月份是实际月份-1
        var sys_second = (end_time - new Date().getTime()) / 1000;
        var timer = setInterval(function () {
            if (sys_second > 1) {
                sys_second -= 1;
                var day = Math.floor((sys_second / 3600) / 24);
                var hour = Math.floor((sys_second / 3600) % 24);
                var minute = Math.floor((sys_second / 60) % 60);
                day_elem && $(day_elem).text(day);//计算天
                $(hour_elem).text(hour < 10 ? "0" + hour : hour);//计算小时
                $(minute_elem).text(minute < 10 ? "0" + minute : minute);//计算分钟
            } else {
                clearInterval(timer);
            }
        }, 1000);
    }
</script>
</body>
</html>