<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容师人才库管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/gcWeb/talent/">美容师人才库列表</a></li>
    <shiro:hasPermission name="gcWeb:talent:add">
        <li><a href="${ctx}/gcWeb/talent/form">美容师人才库添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="gcWebTalent" action="${ctx}/gcWeb/talent/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>标题：</label>
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>显示标记：</label>
            <form:select path="showFlag" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>标题</th>
        <th>显示标记</th>
        <th>排序</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="gcWebTalent">
        <tr>
            <td>
                    ${gcWebTalent.title}
            </td>
            <td>
                    ${fns:getDictLabel(gcWebTalent.showFlag, 'show_hide', '')}
            </td>
            <td>
                    ${gcWebTalent.sort}
            </td>
            <td>
                <shiro:lacksPermission name="gcWeb:talent:edit">
                    <a href="${ctx}/gcWeb/talent/form?id=${gcWebTalent.id}">查看</a>
                </shiro:lacksPermission>
                <shiro:hasPermission name="gcWeb:talent:edit">
                    <a href="${ctx}/gcWeb/talent/form?id=${gcWebTalent.id}">修改</a>
                </shiro:hasPermission>
                <shiro:hasPermission name="gcWeb:talent:del">
                    <a href="${ctx}/gcWeb/talent/delete?id=${gcWebTalent.id}"
                       onclick="return confirmx('确认要删除该美容官网人才库吗？', this.href)">删除</a>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>