<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单项目管理</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-search .ul-form li label {
		    width: 96px;
		    text-align: left;
		    margin-left: 15px;
		}
		.input-mini{
			width:60px!important;
		}
		.jbox-body .jbox-icon{
			top:50px!important;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function() {
		});
		function deleteContent(obj){
			$.jBox.confirm("确认要删除吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					$(obj).parent().parent().remove();
				}
			},{buttonsFocus:1});
		}
		function addRefundOrder(){
			var queryOrderCode = $("#queryOrderCode").val();
			if(queryOrderCode == null || queryOrderCode==""){
				$.jBox.error("请输入要退款的订单号！","系统提示");
				return false;
			}
			var repeatRefundOrderFlag = false;
			$("#orderRefundContent input[name='orderCode']").each(function(){
				if($(this).val() == queryOrderCode){
					repeatRefundOrderFlag = true;
					return false;
				}
			});
			if(repeatRefundOrderFlag){
				$.jBox.error("订单号为"+queryOrderCode+"的信息已录入！","系统提示");
				return false;
			}
			loadFun("addRefundOrderBtn");
			$.ajax({
				type:'get',
				url:'${ctx}/finance/paymentOrderRefund/order/'+queryOrderCode,
				dataType:'html', 
				success : function(html) {
					closeLoadFun("addRefundOrderBtn");
					if(html != null && html != ""){
						if(!$.trim(html).startsWith("<tr",0)){
							$.jBox.error(html,"系统提示");
							return false;
						}
						$("#orderRefundContent").append(html);
						$('select').select2();
						$("#queryOrderCode").val("");
						
					}
				},
				error:function(){
					closeLoadFun("addRefundOrderBtn");
					$.jBox.error("网络或服务异常，请检查是否联网！","系统提示");
				}
			});
		}
		
		function saveRefundOrder(){
			if($(".refund-body").size() == 0){
				$.jBox.error("还未录入退款单，请添加退款单后重试！","系统提示");
				return;
			}
			$.jBox.confirm("确认要进行此操作吗？","系统提示",function(v,h,f){
				if(v=="ok"){
					var refundOrderArray = [];
					$(".refund-body").each(function(index,self){
						var refundOrder = {};
						$(self).find("input,select,textarea").each(function(index1,self1){
							if($(self1).attr("name") != null && $(self1).attr("name") != ''){
								refundOrder[$(self1).attr("name")] = $.trim($(self1).val());
							}
						});
						console.log(refundOrder);
						refundOrderArray.push(refundOrder);
					});
					
					//校验订单金额
					for(index in refundOrderArray){
						var refundOrder = refundOrderArray[index];
						if(refundOrder.partRefundFlag == 'true'){
							if(refundOrder.partRefundPrice == undefined || refundOrder.partRefundPrice == null || refundOrder.partRefundPrice == ""){
								$.jBox.error("请输入订单号"+refundOrder.orderCode+"的退款金额！","系统提示");
								return;
							}else if(parseInt(refundOrder.partRefundPrice) <= 0){
								$.jBox.error("订单号"+refundOrder.orderCode+"的退款金额错误，请重新输入！","系统提示");
								return;
							}else if(parseInt(refundOrder.partRefundPrice) >= parseInt(refundOrder.totalPrice)){
								$.jBox.error("订单号"+refundOrder.orderCode+"的退款金额应小于订单金额，请重新输入！","系统提示");
								return;
							}
						}
						if(refundOrder.chargingItemId  == undefined || refundOrder.chargingItemId == null || refundOrder.chargingItemId == "" ){
							$.jBox.error("请选择订单号"+refundOrder.orderCode+"的缴费项目！","系统提示");
							return;
						}
					}
					loadFun("saveRefundOrderBtn");
					$.ajax({
						url:'${ctx}/finance/paymentOrderRefund/save',
						data:JSON.stringify(refundOrderArray),
						contentType: 'application/json;charset=UTF-8',
						type:'post',
						cache:false,
						success:function(json){
							closeLoadFun("saveRefundOrderBtn");
							if(json.rc==0){
								alert("处理退款成功!");
								//$.jBox.alert("处理退款成功!","系统提示",{"icon":"success"});
								window.location.href = "${ctx}/finance/paymentOrderRefund/";
							}else{
								$.jBox.error(json.msg,"系统提示");
							}
						},
						error:function(){
							closeLoadFun("saveRefundOrderBtn");
							$.jBox.error("网络或服务异常，请检查是否联网！","系统提示");
						}
					});
					
				}
			},{buttonsFocus:2,buttons: {'取消':'cancel','确定':'ok'}});
		}
		
		function partRefundChange(obj,partId){
			if($(obj).val() == 'true'){
				$("#partRefundPrice"+partId).prop("readonly",false);
				$("#partRefundPriceReq"+partId).show();
			}else{
				$("#partRefundPrice"+partId).prop("readonly",true);
				$("#partRefundPriceReq"+partId).hide();
				$("#partRefundPrice"+partId).val($("#totalPrice"+partId).val());
			}
			$("#partRefundFlag"+partId).val($(obj).val());
		}
		
		function chargingItemChange(obj,partId){
			$("#chargingItemName"+partId).val($.trim($(obj).find("option:selected").html()));
		}
		
		function loadFun(btnId){
			layer.load();
			$("#"+btnId).prop("disabled",true);
		}
		
		function closeLoadFun(btnId){
			layer.closeAll('loading');
			$("#"+btnId).prop("disabled",false);
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentOrderRefund/">退费记录列表</a></li>
		<li class="active"><a href="${ctx}/finance/paymentOrderRefund/form?id=${paymentOrderRefund.id}">退费记录添加</a></li>
	</ul><br/>
	<div class="panel panel-default">
		<div class="panel-body">
			<form:form id="searchForm" modelAttribute="paymentOrderProject" action="${ctx}/finance/paymentOrderRefund/order" method="post" class="breadcrumb form-search">
				<ul class="ul-form">
					<li>
						<label style="font-size: 14px;">订单编号：</label>
						<input id="queryOrderCode" class="input-xlarge" type="text" placeholder="请输入要退款的单据编号" maxlength="100">
						<input type="reset" value="清除" style="border:1px solid #ddd;padding: 3px 7px;border-radius:4px;">
					</li>
					<shiro:hasPermission name="finance:paymentOrderRefund:edit">
						<li class="btns">
							<input id="addRefundOrderBtn" onclick="addRefundOrder()" class="btn btn-primary" type="button" value="添加退款订单"/>
						</li>
						<li class="btns">
							<input id="saveRefundOrderBtn" onclick="saveRefundOrder()" class="btn btn-danger" type="button" value="提交"/>
						</li>
					</shiro:hasPermission>
					<li class="clearfix"></li>
				</ul>
			</form:form>
		</div>
	</div>
	
	<ul class="nav nav-tabs"></ul>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th style="width:15%;min-width:182px;">订单编号</th>
				<th style="width:5%;">会员名称</th>
				<th style="width:5%;">订单金额</th>
				<th style="width:10%;">部分退费</th>
				<th style="width:15%;">部分退费金额</th>
				<th style="width:10%;">缴费项目</th>
				<th style="width:35%;">备注信息</th>
				<th style="width:5%;">操作</th>
			</tr>
		</thead>
		<tbody id="orderRefundContent">
			<c:forEach items="${orderRefunds}" var="order">
				<tr id="${order.id}" class="refund-body">
					<td class="col-xs-6">
						<input name="orderCode" value="${order.orderCode}" class="input-large" type="hidden" readonly="true">
						<div class="input-small">${order.orderCode}</div>
					</td>
					<td>
						<input name="memberCode" value="${order.memberCode}" class="input-medium" type="hidden">
						<input name="memberName" value="${order.memberName}" class="input-medium" type="hidden">
						<div class="input-small">${order.memberName}${empty order.memberCode? '' :'（ '.concat(order.memberCode.concat(' ）'))}</div>
					</td>
					<td>
						<input id="totalPrice${order.id}" name="totalPrice" value="${order.totalPrice}" class="input-mini" type="hidden" style="margin-top:10px;" readonly="true">
						<div class="input-mini">${order.totalPrice}</div>
					</td>
					<td>
						<input id="partRefundFlag${order.id}" name="partRefundFlag" value="false" class="input-medium" type="hidden">
						<div style="min-width:70px;">
					        <span><input onclick="partRefundChange(this,'${order.id}');" name="partRefundFlagRadio${order.id}" type="radio" value="true"><label>是</label></span>
					        <span><input onclick="partRefundChange(this,'${order.id}');" name="partRefundFlagRadio${order.id}" type="radio" value="false" checked="checked"><label>否</label></span>
				        </div>
					</td>
					<td>
					
						<input id="partRefundPrice${order.id}" name="partRefundPrice" value="${order.totalPrice}" placeholder="该金额应小于订单金额" class="input-medium" type="number" min="1" max="${order.totalPrice}" style="margin-top:10px;" readonly="true">
					</td>
					<td> 
						<input id="chargingItemName${order.id}" name="chargingItemName" value="" class="input-medium" type="hidden">
						<select id="chargingItemId${order.id}" name="chargingItemId" class="input-medium" onchange="chargingItemChange(this,'${order.id}');">
							<option value="">请选择</option>
							<c:forEach items="${itemList}" var="item">
					        	<option value="${item.id}">${item.name}</option>
							</c:forEach>
				        </select>
				        <span id="chargingItemIdReq${order.id}" style="display: none;" class="help-inline"><font color="red">*</font> </span>
					</td>
					<td>
						<input name="refundRemark" placeholder="请输入备注信息" type="text" value="${order.refundRemark}" style="margin-top:10px;width:320px;">
					</td>
					<td>
						<image src="${ctxStatic}/img/remove.png" onclick="deleteContent(this)" style="cursor:pointer;width: 16px;height:16px;padding:0px 5px 0px 5px;z-index:10;box-sizing:initial;"/>
					</td>
				</tr>
			</c:forEach>
<%-- 		<jsp:include page="paymentOrderRefundForm.jsp"></jsp:include> --%>
		</tbody>
	</table>
	
</body>
</html>