<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>收费项目管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/finance/paymentChargingItem/">收费项目列表</a></li>
    <li class="active"><a href="${ctx}/finance/paymentChargingItem/view?id=${paymentChargingItem.id}">收费项目查看</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="paymentChargingItem" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">收费项目名：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:escapeHtml(paymentChargingItem.name)}">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">金额：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:escapeHtml(paymentChargingItem.price)}">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">部门：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:escapeHtml(paymentChargingItem.office.name)}">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">排序字段：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:escapeHtml(paymentChargingItem.sort)}">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">会员可见度：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:getDictLabel(paymentChargingItem.visibility, 'charging_item_visibility', '')}">
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">是否可以分摊：</label>
        <div class="controls">
            <form:select path="isShare" class="input-xlarge " disabled="true">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
            </form:select>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">分摊月份（单位为月）：</label>
        <div class="controls">
            <form:input path="shareSection" htmlEscape="false" maxlength="11" class="input-xlarge digits" readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">业务表名：</label>
        <div class="controls">
            <form:input path="businessTable" htmlEscape="false" class="input-xlarge" readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <input type="text" readonly value="${fns:escapeHtml(paymentChargingItem.remarks)}">
        </div>
    </div>
    <div class="form-actions">
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>