<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
	<title>会员订单扣款</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        let orderRequestJson;
        $(document).ready(function () {
            orderRequestJson = util.getLSItem("orderRequestJson");
            util.removeLSItem("orderRequestJson");
            if (orderRequestJson == null) {
                alert("网络错误，请重试")
                closeLayer();
            }
            $.ajax({
                type: "POST",
                dataType: "json",
                contentType: "application/json;charset=UTF-8",
                url: "${ctxApi}/v2/order/pre",
                data: orderRequestJson,
                async: false,
                error: function (request, textStatus, errorThrown) {
                    alert("网络错误，请重试");
                },
                success: function (data) {
                    if (data.rc == "0") {
                        let orderTotalPrice = 0;
                        $.each(data.data.skuList, function (i, sku) {
                            orderTotalPrice += sku.totalPrice;
                            $("#tbody").append(
                                "<tr>" +
                                "<td>" + sku.skuName + "</td>" +
                                "<td>" + sku.unitPrice + "</td>" +
                                "<td>" + sku.num + "</td>" +
                                "<td>" + sku.totalPrice + "</td>" +
                                "</tr>"
                            )
                        });
                        $("#orderTotalPrice").val(orderTotalPrice);
                        $("#paymentAmount").val(orderTotalPrice);
                    }
                }
            });
        });

        function closeLayer() {
            parent.layer.closeAll();
        }

        function save() {
            var orderTotalPrice = $("#orderTotalPrice").val();
            var accountBalance = $("#accountBalance").val();
            console.log()
            if (parseFloat(orderTotalPrice) - parseFloat(accountBalance) > 0) {
                alert("会员余额不足，请先充值！");
                return;
            }
            $("#btnSubmit").attr("disabled", true);
            $("#btnCancel").attr("disabled", true);

            $.ajax({
                type: "POST",
                url: "${ctxApi}/v2/order/commit/balancePay",
                dataType: "json",
                contentType: "application/json;charset=UTF-8",
                data: orderRequestJson,
                async: true,
                error: function (request, textStatus, errorThrown) {
                    alert(request.responseText + "请联系管理员！");
                },
                success: function (data) {
                    if (data.rc == 0) {
                        alert("扣款成功！");
                        parent.isYes = true;
                        parent.layer.closeAll();
                    } else {
                        alert("错误代码：" + data.rc + "错误信息：" + data.msg);
                        $("#btnSubmit").attr("disabled", false);
                        $("#btnCancel").attr("disabled", false);
                    }
                }
            });
        }
	</script>
	<style>
        form {
            padding-top: 20px;
        }

        .control-group {
            border-bottom: 0px;
        }
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="member" class="form-horizontal">
	<div id="skuInfo">
		<table id="contentTable" class="table table-striped table-bordered table-condensed"
		       style="width: 500px;margin: 0 auto">
			<thead>
			<tr>
				<th>商品名称</th>
				<th>单价</th>
				<th>数量</th>
				<th>总价</th>
			</tr>
			</thead>
			<tbody id="tbody">
			</tbody>
		</table>
	</div>
	<div class="control-group" style="margin-top: 20px">
		<label class="control-label">订单总金额：</label>
		<div class="controls">
			<input id="orderTotalPrice" type="number" readonly class="input-xlarge">
		</div>
	</div>
<%--	<div class="control-group">--%>
<%--		<label class="control-label">实扣金额：</label>--%>
<%--		<div class="controls">--%>
<%--			<input id="paymentAmount" type="number" step="0.01" min="0"--%>
<%--			       <shiro:lacksPermission name="finance:deductCost:other">readonly</shiro:lacksPermission>--%>
<%--			       name="paymentAmount" placeholder="实扣金额！" class="input-xlarge">--%>
<%--		</div>--%>
<%--	</div>--%>
	<div class="control-group">
		<label class="control-label">会员编号：</label>
		<div class="controls">
			<input type="text" readonly="readonly" name="memberCode" value="${member.memberCode}" htmlEscape="false"
			       maxlength="60" class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">姓名：</label>
		<div class="controls">
			<input type="text" readonly="readonly" value="${member.name}" htmlEscape="false" maxlength="100"
			       class="input-xlarge"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">会员余额：</label>
		<div class="controls">
			<input type="text" readonly="readonly" id="accountBalance" value="${member.accountBalance}"
			       class="input-xlarge">
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="button" value="余额缴费" onclick="save()"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>