<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>会员账户余额统计</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {

        });
        function changeTotalTimeType(type){
            var arr = null;
            if(type==0){
                arr = util.getCurrentMonth();
            }else{
                arr = util.getCurrentYear();
            }
            if(arr!=null && arr.length>0){
                $("#startPaymentTime").val(util.formatDateLong(arr[0]));
                $("#endPaymentTime").val(util.formatDateLong(arr[1]));
                $("form").submit();
            }

        };

        function searchDetail(type){
            var memberCode = $("#memberCode").val();
            var startPaymentTime = $("#startPaymentTime").val();
            var endPaymentTime = $("#endPaymentTime").val();
            location.href="${ctx}/finance/memberAccount/searchStatisticsDetail?type="+type+"&memberCode="+memberCode+"&paymentTimeStart="+startPaymentTime+"&paymentTimeEnd="+endPaymentTime;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/finance/memberBalance/getListByMemberCode">会员账户余额明细</a></li>
    <li class="active"><a href="${ctx}/finance/memberBalance/getListStatistics">会员账户余额统计</a></li>
</ul>
<form:form id="searchForm" modelAttribute="memberBalance" action="${ctx}/finance/memberBalance/getListStatistics" method="post" class="breadcrumb form-search">
    <ul class="ul-form">
        <li><label>会员号：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>开始时间：</label>
            <input name="startPaymentTime" id="startPaymentTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                   value="<fmt:formatDate value="${memberBalance.startPaymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
        </li>
        <li><label>截止时间：</label>
            <input name="endPaymentTime" id="endPaymentTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                   value="<fmt:formatDate value="${memberBalance.endPaymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/><input id="btnMonth" class="btn btn-primary" type="button" onclick="changeTotalTimeType(0)" value="本月"/><input id="btnYear" onclick="changeTotalTimeType(1)" class="btn btn-primary" type="button" value="本年"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>收入类型</th>
        <th>收入总计</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${list}" var="memberBalance">
        <tr>
            <td>
                ${fns:escapeHtml(memberBalance.totalType)}
                    <c:if test="${memberBalance.totalType eq '充值总金额'}">  <input id="rechargeBtn" onclick="searchDetail('recharge')" class="btn btn-primary" type="button" value="查看明细"/></c:if>
                    <c:if test="${memberBalance.totalType eq '余额总扣费'}">  <input id="balanceBtn"  onclick="searchDetail('balance')"  class="btn btn-primary" type="button" value="查看明细"/></c:if>
            </td>
            <td>
                ${fns:escapeHtml(memberBalance.totalPrice)}
            </td>
        </tr>
    </c:forEach>
    <tr>
        <td>
            会员账户余额
        </td>
        <td>
            ${fns:escapeHtml(count)}
        </td>
    </tr>
    </tbody>
</table>
</body>
</html>