<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>血样留存订单录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		var searchFlag = "false";
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					var pedigreeCertified = $("#pedigreeCertified").val();
					var birthCode = $("#birthCode").val();
					var showAppraisalCode = $("#showAppraisalCode").val();
					var overseasPedigreeCertified = $("#overseasPedigreeCertified").val();
					var orgId = $("#orgId").val();
					if(pedigreeCertified==''&&birthCode==''&&showAppraisalCode==''&&overseasPedigreeCertified==''){
						alert("请输入血统证书号或出生纸编号或犬展鉴定编号或外国血统证书号");
						return;
					}
					if(searchFlag!="true"){
						alert("请查询犬只信息后再提交");
						return;
					}
//					if(orgId==""){
//						alert("请查询选择合作机构后再提交");
//						return;
//					}
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/dogbloodsave/dogBloodSave/add',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("订单录入成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							alert("提交失败,错误信息："+data.msg);
 						}
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function getDogByPedigreeCertified(pedigreeCertified){
			searchFlag = "false";
			if(pedigreeCertified==''){
				$.jBox.alert("请输入血统证书号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dnaarchive/dogDnaArchive/getDogByPedigreeCertified', {
		    	pedigreeCertified: pedigreeCertified
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
				searchFlag = "true";
		    });
		}
		function getDogByBirthCode(birthCode){
			searchFlag = "false";
			if(birthCode==''){
				$.jBox.alert("请输入出生纸编号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dnaarchive/dogDnaArchive/getDogByBirthCode', {
				birthCode: birthCode
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
				searchFlag = "true";
		    });
		}
		function getDogByShowAppraisalCode(showAppraisalCode){
			searchFlag = "false";
			if(showAppraisalCode==''){
				$.jBox.alert("请输入犬展鉴定编号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dogappraisal/dogAppraisal/getDogByShowAppraisalCode', {
				showAppraisalCode: showAppraisalCode
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
				searchFlag = "true";
		    });
		}
		function getDogByOverseasPedigreeCertified(overseasPedigreeCertified){
			searchFlag = "false";
			if(overseasPedigreeCertified==''){
				$.jBox.alert("请输入外国血统证书号！","提示");
		    	$('#nameEn').html('');
		    	$('#birthdate').html('');
		    	$('#gender').html('');
		    	$('#colorFlag').html('');
		    	$('#identificationFlag').html('');
		    	$('#dogBreed').html('');
				return;
			}
		    $.post('${ctx}/dnaarchive/dogDnaArchive/getDogByOverseasPedigreeCertified', {
				overseasPedigreeCertified: overseasPedigreeCertified
		    }, function(data) {
		    	$('#nameEn').html(data.nameEn);
		    	$('#birthdate').html(data.birthdate);
		    	$('#gender').html(data.gender);
		    	$('#colorFlag').html(data.colorFlag);
		    	$('#identificationFlag').html(data.identificationFlag);
		    	$('#dogBreed').html(data.dogBreed);
				searchFlag = "true";
		    });
		}
		function searchType() {
			var type = $("#type").val();
			var birthCode = $("#birthCode").val();
			if(type == '0'){
				getDogByPedigreeCertified(birthCode)
			}
			if(type == '1'){
				getDogByBirthCode(birthCode)
			}
			if(type == '2'){
				getDogByShowAppraisalCode(birthCode)
			}
			if(type == '3'){
				getDogByOverseasPedigreeCertified(birthCode)
			}
		}
		function getOrgByProvince(){
			var province = $("#province").val();
			$.post('${ctx}/dogbloodsave/dogBloodSave/getOrg', {
				province: province
			}, function(data) {
				$('#orgId').empty();
				$('#orgId').append("<option value =''>选择合作机构</option>");
				$.each(data, function(i,val) {
					$('#orgId').append("<option value ='"+val.id+"'>"+val.name+"</option>");
				});
			});
		}
	</script>

	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogBloodSave" class="form-horizontal">
	<form:hidden path="paymentMemberCode"/>
	<form:hidden path="paymentChargingItemId"/>
	<form:hidden path="runningNumber"/>
	<div class="control-group">
		<label class="control-label">类型：</label>
		<div class="controls">
			<form:select path="type" class="input-xlarge">
				<form:option value="" label="请选择类型"/>
				<form:option value="0" label="血统证书号"/>
				<form:option value="1" label="出生纸编号"/>
				<form:option value="2" label="犬展鉴定编号"/>
				<form:option value="3" label="国外血统证书号"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">编号：</label>
		<div class="controls">
			<form:input id="birthCode" path="birthCode" htmlEscape="false" maxlength="64" class="input-xlarge"/>
			<input  class="btn btn-primary" type="button" value="查询" onclick="searchType()"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">犬种：</label>
		<div class="controls" id="dogBreed"></div>
	</div>
	<div class="control-group">
		<label class="control-label">犬名：</label>
		<div class="controls" id="nameEn"></div>
	</div>
	<div class="control-group">
		<label class="control-label">出生日期：</label>
		<div class="controls" id="birthdate"></div>
	</div>
	<div class="control-group">
		<label class="control-label">性别：</label>
		<div class="controls" id="gender"></div>
	</div>
	<div class="control-group">
		<label class="control-label">毛色：</label>
		<div class="controls" id="colorFlag"></div>
	</div>
	<div class="control-group">
		<label class="control-label">身份标识：</label>
		<div class="controls" id="identificationFlag"></div>
	</div>
	<div class="control-group">
		<label class="control-label">合作机构：</label>
		<div class="controls">
			<form:select path="province" class="input-xlarge" onchange="getOrgByProvince()">
				<form:option value="" label="选择省"/>
				<form:options items="${provinceList}" itemLabel="name" itemValue="name" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<div class="controls">
			<form:select path="orgId" class="input-xlarge">
				<form:option value="" label="选择合作机构"/>
			</form:select>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>