<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>第二繁殖人管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dog/dogSecondBreeder/">第二繁殖人列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogSecondBreeder" action="${ctx}/dog/dogSecondBreeder/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>配种证明编号：</label>
				<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>姓名/会员号：</label>
				<form:input path="breederMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>申请时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogSecondBreeder.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogSecondBreeder.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>配种证明编号</th>
				<th>繁殖人</th>
				<th>第二繁殖人</th>
				<th>申请日期</th>
				<th>缴费状态</th>
				<th>审核状态</th>
				<th>处理</th>
				<th>管理</th>
				<shiro:hasPermission name="dog:dogSecondBreeder:edit"><th>删除</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogSecondBreeder">
			<tr>
				<td><a href="${ctx}/dog/dogSecondBreeder/form?id=${dogSecondBreeder.id}">
					${dogSecondBreeder.breedCertifiedCode}
				</a></td>
				<td>
					${dogSecondBreeder.breeder}
				</td>
				<td>
					${dogSecondBreeder.secondBreeder}
				</td>
				<td>
					<fmt:formatDate value="${dogSecondBreeder.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:getDictLabel(dogSecondBreeder.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<c:choose>
						<c:when test="${dogSecondBreeder.reviewState == '0'}">
							<a href="${ctx}/dog/dogSecondBreeder/review?id=${dogSecondBreeder.id}">待审核</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogSecondBreeder.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<c:choose>
						<c:when test="${dogSecondBreeder.reviewState == '0'}">
							--
						</c:when>
						<c:when test="${dogSecondBreeder.reviewState == '1' && dogSecondBreeder.processState == '0'}">
							<a href="${ctx}/dog/dogSecondBreeder/process?id=${dogSecondBreeder.id}">处理</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogSecondBreeder.processState, 'proccess_state', '')}
						</c:otherwise>
					</c:choose>

				</td>
				<td>
					<a href="${ctx}/dog/dogSecondBreeder/form?id=${dogSecondBreeder.id}">查看</a>
				</td>
				<shiro:hasPermission name="dog:dogSecondBreeder:edit"><td>
					<a href="${ctx}/dog/dogSecondBreeder/delete?id=${dogSecondBreeder.id}" onclick="return confirmx('确认要删除该第二繁殖人吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>