<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只芯片会员锁定管理</title>
    <meta name="decorator" content="default"/>
    <script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    // loading('正在提交，请稍等...');
                    // form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //初始化
            if ('${dogChipMemberLock.id}' != '') {
                $("#memberCode").attr("readOnly","readOnly");
                $("#identificationFlag").attr("readOnly","readOnly");
            }else{
                $("#lockState").val("1").trigger("change");
            }

            //保存事件
            $("#btnSubmit").click(function () {
                $("#inputForm").ajaxSubmit({
                    dataType: 'json',
                    beforeSubmit: function () {
                        if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
                            return false;
                        } else {
                            return true;
                        }
                    },
                    success: function (data) {
                        if (data.rc == 0) {
                            layer.msg(data.msg);
                            window.location = "${ctx}/dog/dogChipMemberLock/list"
                        } else {
                            layer.msg(data.msg);
                        }
                    },
                    error: function (err) {
                        layer.msg("操作失败!");
                    }
                });
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dog/dogChipMemberLock/">犬只芯片会员锁定列表</a></li>
    <li class="active"><a
            href="${ctx}/dog/dogChipMemberLock/form?id=${dogChipMemberLock.id}">犬只芯片会员锁定<shiro:hasPermission
            name="dog:dogChipMemberLock:edit">${not empty dogChipMemberLock.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission
            name="dog:dogChipMemberLock:edit">查看</shiro:lacksPermission></a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogChipMemberLock" action="${ctx}/dog/dogChipMemberLock/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">会员号：</label>
        <div class="controls">
            <form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div class="controls">
            <form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">锁定状态：</label>
        <div class="controls">
            <form:select path="lockState" class="input-xlarge required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注信息：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="dog:dogChipMemberLock:edit">
            <input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
        </shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>