<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬主变更编辑</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#inputForm").validate({
                submitHandler: function (form) {
                    save();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

        });

        function save() {
            var dogId = $("#dogId").val();
            var identificationFlag = $("#identificationFlag").val();
            var tempIdentificationFlag = $("#tempIdentificationFlag").val();
            if (dogId == '' || tempIdentificationFlag != identificationFlag) {
                alert("请先查询出犬只信息！");
                $('#dogId').val('');
                return;
            }
            loading('正在提交，请稍等...');
            var frm = $("#inputForm");
            var dataPara = util.getFormJson(frm);
            $.ajax({
                url: '${ctx}/catx/dog/dogOwnerChange/add',
                type: 'POST',
                data: dataPara,
                async: false,
                success: function (json) {
                    if (json.rc == 0) {
                        layer.msg(json.msg);
                        window.location = "${ctx}/catx/dog/dogOwnerChange/list"
                    } else {
                        layer.msg(json.msg);
                    }
                }
            });
        }

        function getDogByIdentificationFlag() {
            var identificationFlag = $("#identificationFlag").val();
            if (identificationFlag == '') {
                alert("请先填写芯片号！");
                $('#dogId').val('');
                return;
            }
            $.post('${ctx}/catx/dog/dogOwnerChange/info/' + identificationFlag, {}, function (json) {
                if (json.rc == 0) {
                    $('#tempIdentificationFlag').val(identificationFlag);
                    $('#dogId').val(json.data.id);
                    $('#originOwnerName').val(json.data.memberName);
                    $('#originOwnerMemberCode').val(json.data.memberCode);
                    $('#newOwnerName').val(json.data.newMemberName);
                    $('#newOwnerMemberCode').val(json.data.newMemberCode);
                } else {
                    layer.msg(json.msg);
                }
            });
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/catx/dog/dogOwnerChange/">犬主变更列表</a></li>
    <li class="active"><a href="${ctx}/catx/dog/dogOwnerChange/addForm">犬主变更添加</a></li>
</ul>
<form:form id="inputForm" modelAttribute="dogOwnerChange" method="post" class="form-horizontal">
    <form:hidden path="dogId"/>
    <input id="tempIdentificationFlag" type="hidden">
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">芯片号：</label>
        <div class="controls">
            <input id="identificationFlag" type="text" htmlEscape="false" maxlength="64" class="input-xlarge ">
            <input id="search" class="btn btn-primary" type="button" value="查" onclick="getDogByIdentificationFlag()"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">原犬主：</label>
        <div class="controls">
            <form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">原犬主会员号：</label>
        <div class="controls">
            <form:input path="originOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "
                        readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">新犬主：</label>
        <div class="controls">
            <form:input path="newOwnerName" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">新犬主会员号：</label>
        <div class="controls">
            <form:input path="newOwnerMemberCode" htmlEscape="false" maxlength="64" class="input-xlarge "
                        readonly="true"/>
        </div>
    </div>
    <div class="form-actions">
        <input id="btnSubmit" class="btn btn-primary" type="submit" value="保存"/>&nbsp;
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>