/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.user;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.kennel.dao.KennelAllianceDao;
import com.cku.oa.kennel.entity.KennelAlliance;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.tcb.dao.TcbKennelDao;
import com.cku.oa.tcb.entity.TcbKennel;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.Office;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 用户会员信息表Controller
 * @author fanhuibin
 * @version 2016-07-13
 */
@Controller
@RequestMapping(value = "/subSystem/user/member")
public class  SubMemberController extends BaseController {

	@Autowired
	private MemberService memberService;
	@Autowired
	private SystemService systemService;
	@Autowired
	private KennelAllianceDao kennelAllianceDao;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private TcbKennelDao tcbKennelDao;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public Member get(@RequestParam(required=false) String id) {
		Member entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = memberService.get(id);
		}
		if (entity == null){
			entity = new Member();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		Office office = UserUtils.getUser().getOffice();
		Page<Member> page = memberService.findPage(new Page<Member>(request, response), member); 
		//遍历所有list，如果是优生繁育联盟的，添加标记
		List<Member> members = page.getList();
		long now = System.currentTimeMillis();
		for(Member m:members){
			KennelAlliance kennelAlliance = kennelAllianceDao.getByMemberCode(m.getMemberCode());
			if(kennelAlliance!=null
					&&kennelAlliance.getStartDate()!=null
					&&kennelAlliance.getEndDate()!=null
					&&kennelAlliance.getStartDate().getTime()<now
					&&kennelAlliance.getEndDate().getTime()>now){
				m.setKennelAlliance(kennelAlliance);
			}
			TcbKennel tcbKennel = tcbKennelDao.getByMemberCode(m.getMemberCode());
			if(tcbKennel!=null
					&&tcbKennel.getStartDate()!=null
					&&tcbKennel.getEndDate()!=null
					&&tcbKennel.getStartDate().getTime()<now
					&&tcbKennel.getEndDate().getTime()>now){
				m.setTcbKennel(tcbKennel);
			}
		}
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/user/memberList";
	}
	
	
	@RequestMapping(value = "view")
	public String view(Member member, Model model,HttpServletRequest request, HttpServletResponse response) {
		model.addAttribute("member", member);
		String memberCode = member.getMemberCode();
		PaymentOrder pyo=new PaymentOrder();
		pyo.setMemberCode(memberCode);
		 List<PaymentOrder> findList = paymentOrderService.findList(pyo);
		model.addAttribute("list",findList);
		Map<String, String> map = paymentOrderDao.getConsumeMsgByMemberCode(memberCode);
		model.addAttribute("in_price", map.get("in_price"));
		model.addAttribute("out_price", map.get("out_price"));
		model.addAttribute("three_price", map.get("three_price"));
		return "subSystem/"+getUrlByUserType()+"/user/memberView";
	}

}