package com.cku.restful.v2.order.vo.request;

import com.cku.restful.v2.order.enums.OrderSourceEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @author yuanshuai
 * @date 2023/6/16 14:01
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class OrderApplyRequest {

    @ApiModelProperty("业务ID")
    @NotBlank
    private String businessID;

    @ApiModelProperty("订单来源(0:oa,1:android,2:ios)")
    @NotNull
    private OrderSourceEnum orderSource;

    @ApiModelProperty("会员号(订单来源为android和ios时无需传此字段)")
    private String memberCode;

    @ApiModelProperty("业务数据json格式，详见各业务接口")
    @NotBlank
    private String businessData;
}
