package com.cku.restful.v1.show.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.model.CkuHandlerScoreRankingGroupVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingHeadVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingListVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingVO;
import com.cku.oa.handler.service.HandlerScoreRankingService;
import com.cku.oa.show.constant.ShowRankingScoreTypeConstant;
import com.cku.oa.show.service.ShowResultsService;
import com.cku.oa.show.service.ShowScoreRankingService;
import com.cku.restful.v1.show.model.CkuShowScoreRankingAbstractVO;
import com.cku.restful.v1.show.model.CkuShowScoreRankingDqzAbstract;
import com.cku.restful.v1.show.model.CkuShowScoreRankingGroupAbstract;
import com.cku.restful.v1.show.model.CkuShowScoreRankingMaxMonth;
import com.cku.restful.v1.show.model.CkuShowScoreRankingMonths;
import com.cku.restful.v1.show.model.CkuShowScoreRankingSearchVO;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiOperation;

/**
 * 新版官网积分榜
 * 
 * @author admin
 *
 */
@Controller
//@RequestMapping(value = "/cku/v1/shows/new")
@RequestMapping(value = "/")
public class CkuShowsNewController extends BaseRestController {

	@Autowired
	private ShowScoreRankingService showScoreRankingService;

	@Autowired
	private ShowResultsService showResultsService;
	
	@Autowired
	private HandlerScoreRankingService handlerScoreRankingService;

//	/**
//	 * 刷新排名
//	 * 
//	 * @param request
//	 * @param response
//	 * @throws IOException
//	 */
//	@RequestMapping(value = "/v1/shows/new/createRankings", method = RequestMethod.GET)
//	@ResponseBody
//	public void createRankings(HttpServletRequest request, HttpServletResponse response) throws IOException {
//		showScoreRankingService.createRankings();
//
//	}


	@ApiOperation(value = "获得组内犬种名称", tags = { "" })
	@RequestMapping(value = "/api/v1/open/shows/new/getFciDogByGroupId", method = RequestMethod.GET)
	@ResponseBody
	public void getFciDogByGroupIdOpen(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String groupId = request.getParameter("groupId");
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		
		ServletUtils.writeResponse(response, showScoreRankingService.getFciDogByGroupId(groupId, year, scoreType));
	}
	
	@ApiOperation(value = "获得组内犬种名称", tags = { "" })
	@RequestMapping(value = "/cku/v1/shows/new/getFciDogByGroupId", method = RequestMethod.GET)
	@ResponseBody
	public void getFciDogByGroupId(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String groupId = request.getParameter("groupId");
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		
		ServletUtils.writeResponse(response, showScoreRankingService.getFciDogByGroupId(groupId, year, scoreType));
	}

	@RequestMapping(value = "/api/v1/open/shows/new/score/rank", method = RequestMethod.GET)
	@ResponseBody
	public void getScoreOpen(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		// groupNo、fciStandardNo 对积分榜结果进行过滤，不传查询全犬种排名
		String groupNo = request.getParameter("groupNo");// 分组号
		String fciStandardNo = request.getParameter("fciStandardNo");// 犬种号
		// 请求多少名
		String rankLimit = request.getParameter("rankLimit");
		// 请求月榜
		String month = request.getParameter("month");
		ServletUtils.writeResponse(response, showScoreRankingService.getScore(groupNo, year,month, scoreType, fciStandardNo,rankLimit));

	}

	@RequestMapping(value = "cku/v1/shows/new/score/rank", method = RequestMethod.GET)
	@ResponseBody
	public void getScore(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		// groupNo、fciStandardNo 对积分榜结果进行过滤，不传查询全犬种排名
		// 分组号
		String groupNo = request.getParameter("groupNo");
		// 犬种号
		String fciStandardNo = request.getParameter("fciStandardNo");
		// 请求多少名
		String rankLimit = request.getParameter("rankLimit");
		// 请求月榜
		String month = request.getParameter("month");
		ServletUtils.writeResponse(response, showScoreRankingService.getScore(groupNo, year,month, scoreType, fciStandardNo,rankLimit));
	}
	
	@RequestMapping(value = "/api/v1/open/shows/score/rank/detail", method = RequestMethod.GET)
	@ResponseBody
	public void getScoreDetailOpen(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		String pedigreeCertified = request.getParameter("pedigreeCertified");

		ServletUtils.writeResponse(response, showScoreRankingService.getScoreDetail(year, scoreType, pedigreeCertified));
	}
	
	@RequestMapping(value = "/cku/v1/shows/score/rank/detail", method = RequestMethod.GET)
	@ResponseBody
	public void getScoreDetail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		String pedigreeCertified = request.getParameter("pedigreeCertified");

		ServletUtils.writeResponse(response, showScoreRankingService.getScoreDetail(year, scoreType, pedigreeCertified));
	}
	
	@ApiOperation(value = "获得全犬种积分榜摘要")
	@GetMapping(value = "cku/v1/shows/new/score/rank/qqzAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingAbstractVO>  getQqzAbstract(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2020) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2020年以前的数据！");
		}
		return showScoreRankingService.getQqzAbstract(year);
	}
	
	@ApiOperation(value = "获得单犬种积分榜摘要")
	@GetMapping(value = "cku/v1/shows/new/score/rank/dqzAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingDqzAbstract>  getDqzAbstract(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2022) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2022年以前的数据！");
		}
		return showScoreRankingService.getDqzAbstract(year,3);
	}
	
	
	@RequestMapping(value = "/api/v1/open/shows/new/score/search", method = RequestMethod.GET)
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingSearchVO> searchScoreOpen(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String year = request.getParameter("year");
		String scoreType = request.getParameter("scoreType");
		// 搜索栏可输入犬主人姓名和犬只证书号进行全局查询
		String key = request.getParameter("key");// 分组号
		
		return showScoreRankingService.searchScoreOpen(year, scoreType, key);
	}
	
	@ApiOperation(value = "APP获得单犬种积分榜摘要")
	@GetMapping(value = "/api/v1/open/shows/score/rank/dqzAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingDqzAbstract>  getDqzAbstractFAPP(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2022) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2022年以前的数据！");
		}
		return showScoreRankingService.getDqzAbstract(year,1);
	}

//	@RequestMapping(value = "/api/v1/open/shows/score/rank/refresh/hm")
//	@ResponseBody
//	public String refreshHm(     HttpServletRequest request, HttpServletResponse response) {
//		String showCode = request.getParameter("showCode");
//		List<String> list =  Arrays.asList(showCode.split(","));
//		showResultsService.refreshHm(list);
//		return "{\"rc\":0}";
//		
//	}
	
	
	@ApiOperation(value = "牵犬师排行榜")
	@GetMapping(value = "cku/v1/handler/rank/abstract")
	@ResponseBody
	public ListResultDto<CkuHandlerScoreRankingGroupVO>  getHandlerScoreRankingAbstract(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		String tableType = request.getParameter("tableType");// 榜单类型：M月榜 Q季度榜 Y年榜
		
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(StringUtils.isBlank(tableType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "tableType必传！");
		}
		return handlerScoreRankingService.getHandlerScoreRankingAbstract(year,tableType,10);
	}
	
	
	@ApiOperation(value = "牵犬师完整榜单获得头")
	@GetMapping(value = "cku/v1/handler/rank/head")
	@ResponseBody
	public ResultDto<CkuHandlerScoreRankingHeadVO>  getHandlerScoreRankingHead(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		return handlerScoreRankingService.getHandlerScoreRankingHead(year);
	}
	
	@ApiOperation(value = "牵犬师排行榜完整榜单查询")
	@GetMapping(value = "cku/v1/handler/rank")
	@ResponseBody
	public ResultDto<CkuHandlerScoreRankingListVO>  getHandlerScoreRanking(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		String tableType = request.getParameter("tableType");// 榜单类型：M月榜 Q季度榜 Y年榜
		String num = request.getParameter("num");
		
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(StringUtils.isBlank(tableType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "tableType必传！");
		}
		if(StringUtils.isBlank(num)&&!"Y".equals(tableType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "num必传！");
		}
		
		return handlerScoreRankingService.getHandlerScoreRanking(Integer.valueOf(year),tableType,StringUtils.isBlank(num)?null:Integer.valueOf(num));
	}
	
	@ApiOperation(value = "详情")
	@GetMapping(value = "cku/v1/handler/rank/detail")
	@ResponseBody
	public ResultDto<CkuHandlerScoreRankingVO>  getHandlerScoreRankingDetail(HttpServletRequest request) throws Exception {
		String id = request.getParameter("id");
		if(StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id必传！");
		}
		
		return handlerScoreRankingService.getHandlerScoreRankingDetail(id);
	}
	
	@ApiOperation(value = "获得幼小特幼有数据的月份", tags = { "" })
	@RequestMapping(value = "/cku/v1/shows/getMonths", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<CkuShowScoreRankingMonths>  getMonths(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		return showScoreRankingService.getMonths( year);
	}
	
	@ApiOperation(value = "获得幼小特幼最近月份", tags = { "" })
	@RequestMapping(value = "/api/v1/open/shows/getMaxMonth", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<CkuShowScoreRankingMaxMonth>  getMaxMonth(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		return showScoreRankingService.getMaxMonth( year);
	}
	
	@ApiOperation(value = "获得组别榜摘要")
	@GetMapping(value = "cku/v1/shows/new/score/rank/groupAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingGroupAbstract>  getGroupAbstract(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2022) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2022年以前的数据！");
		}
		return showScoreRankingService.getGroupAbstract(year,3);
	}
	
	
	@ApiOperation(value = "APP获得组别榜摘要")
	@GetMapping(value = "/api/v1/open/shows/score/rank/groupAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingGroupAbstract>  getGroupAbstractFAPP(@RequestParam("year") String year,
			HttpServletRequest request) throws Exception {
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2022) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2022年以前的数据！");
		}
		
		return showScoreRankingService.getGroupAbstract(year,3);
	}
	
	
	
	@ApiOperation(value = "获得香港积分榜摘要")
	@GetMapping(value = "cku/v1/shows/new/score/rank/HKAbstract")
	@ResponseBody
	public ListResultDto<CkuShowScoreRankingAbstractVO>  getHKAbstract(HttpServletRequest request) throws Exception {
		String year = request.getParameter("year");
		if(StringUtils.isBlank(year)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "year必传！");
		}
		if(Integer.valueOf(year)<2024) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "接口不支持查询2024年以前的数据！");
		}
		return showScoreRankingService.getHKAbstract(year);
	}
	
	
}
